/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import com.google.common.base.Strings;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginClassLoader;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginDescriptor
implements PluginDescriptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginDescriptor.class);
    private final URL source;
    private final PluginClassLoader classLoader;
    private final Manifest manifest;
    private Optional<Class<?>> pluginClass = Optional.empty();
    private final String pluginId;
    private final String pluginClassName;
    private final String version;
    private final Set<String> pluginDependencies;

    public DefaultPluginDescriptor(URL source, PluginClassLoader classLoader, Manifest manifest) {
        this.source = source;
        this.classLoader = classLoader;
        this.manifest = manifest;
        this.pluginClassName = manifest.getMainAttributes().getValue("Riskscape-Plugin");
        if (this.pluginClassName == null) {
            throw new RuntimeException(String.format("Manifest from %s does not include a Riskscape-Plugin entry", source));
        }
        String manifestId = manifest.getMainAttributes().getValue("Riskscape-Plugin-ID");
        if (manifestId == null) {
            log.info(String.format("Plugin from %s does not define a plugin id, using plugin class name %s", source, this.pluginClassName));
            this.pluginId = this.pluginClassName;
        } else {
            this.pluginId = manifestId;
        }
        String manifestVersion = manifest.getMainAttributes().getValue("Riskscape-Plugin-Version");
        this.version = manifestVersion != null ? manifestVersion : "unknown";
        String dependencies = manifest.getMainAttributes().getValue("Riskscape-Plugin-Dependency-IDs");
        this.pluginDependencies = !Strings.isNullOrEmpty((String)dependencies) ? Arrays.asList(dependencies.split(",")).stream().map(String::trim).filter(str -> !str.isEmpty()).collect(Collectors.toSet()) : Collections.emptySet();
        classLoader.setPluginDescriptor(this);
    }

    public boolean hasPluginDependencies() {
        return !this.pluginDependencies.isEmpty();
    }

    public Path getSourcePath() {
        try {
            return Paths.get(this.getSource().toURI());
        }
        catch (URISyntaxException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    public void addDependency(PluginDescriptor dependencyDescriptor) {
        if (!(dependencyDescriptor instanceof DefaultPluginDescriptor)) {
            throw new IllegalArgumentException("DefaultPluginDescriptor can only depend on other DefaultPluginDescriptor instances");
        }
        this.classLoader.addDependency(((DefaultPluginDescriptor)dependencyDescriptor).classLoader);
    }

    public ClassLoader getI18nClassLoader() {
        return this.classLoader.getI18nResourceLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin newPluginInstance() {
        Constructor<?> constructor;
        String className = this.getPluginClassName();
        try {
            Class<?> loadedClass = this.classLoader.loadClass(className);
            if (!Plugin.class.isAssignableFrom(loadedClass)) {
                throw new PluginRuntimeException((PluginDescriptor)this, null, "Plugin class %s does not extend %s", new Object[]{loadedClass, Plugin.class});
            }
            Class<?> loadedPluginClass = loadedClass;
            constructor = loadedPluginClass.getConstructor(PluginDescriptor.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginRuntimeException((PluginDescriptor)this, (Throwable)e, "Plugin source %s does not include class %s", new Object[]{this.getSource(), className});
        }
        catch (NoSuchMethodException e) {
            throw new PluginRuntimeException((PluginDescriptor)this, (Throwable)e, "Plugin class %s does not define %s(%s)", new Object[]{className, className, PluginDescriptor.class});
        }
        catch (Throwable e) {
            throw new PluginRuntimeException((PluginDescriptor)this, e, "Could not initialize plugin %s", new Object[]{this});
        }
        ClassLoader classLoaderToRestore = Thread.currentThread().getContextClassLoader();
        try {
            Plugin constructed;
            Thread.currentThread().setContextClassLoader(classLoaderToRestore);
            try {
                constructed = (Plugin)constructor.newInstance(this);
            }
            catch (Throwable e) {
                throw new PluginRuntimeException((PluginDescriptor)this, e, "Could not create instance of plugin class using %s from plugin %s", new Object[]{constructor, this});
            }
            Plugin plugin = constructed;
            return plugin;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoaderToRestore);
        }
    }

    @Generated
    public String toString() {
        return "DefaultPluginDescriptor(source=" + String.valueOf(this.getSource()) + ", pluginId=" + this.getPluginId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultPluginDescriptor)) {
            return false;
        }
        DefaultPluginDescriptor other = (DefaultPluginDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URL this$source = this.getSource();
        URL other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultPluginDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URL $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }

    @Generated
    public URL getSource() {
        return this.source;
    }

    @Generated
    public PluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public Manifest getManifest() {
        return this.manifest;
    }

    @Generated
    public Optional<Class<?>> getPluginClass() {
        return this.pluginClass;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public String getPluginClassName() {
        return this.pluginClassName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Set<String> getPluginDependencies() {
        return this.pluginDependencies;
    }
}

