/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;

public class BuiltInPluginDescriptor
implements PluginDescriptor {
    private final String pluginId;
    private final BuildInfo buildInfo;
    private final Class<? extends Plugin> pluginClass;
    private final Path sourcePath;

    public static <T extends Plugin> T testPlugin(Class<T> pluginClass) {
        return BuiltInPluginDescriptor.testPlugin(pluginClass, Paths.get(".", new String[0]));
    }

    public static <T extends Plugin> T testPlugin(String pluginId, Class<T> pluginClass, Path sourcePath) {
        BuiltInPluginDescriptor pluginDescriptor = new BuiltInPluginDescriptor(pluginId, BuildInfo.UNKNOWN, pluginClass, sourcePath);
        return (T)((Plugin)pluginClass.cast(pluginDescriptor.newPluginInstance()));
    }

    public static <T extends Plugin> T testPlugin(Class<T> pluginClass, Path sourcePath) {
        return BuiltInPluginDescriptor.testPlugin(pluginClass.getSimpleName(), pluginClass, sourcePath);
    }

    public ClassLoader getI18nClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Plugin newPluginInstance() {
        try {
            Constructor<? extends Plugin> constructor = this.pluginClass.getConstructor(PluginDescriptor.class);
            return constructor.newInstance(this);
        }
        catch (ReflectiveOperationException e) {
            throw new PluginRuntimeException((PluginDescriptor)this, (Throwable)e, "Could not create plugin", new Object[0]);
        }
    }

    public boolean hasPluginDependencies() {
        return false;
    }

    public Set<String> getPluginDependencies() {
        return Collections.emptySet();
    }

    public void addDependency(PluginDescriptor dependencyDescriptor) {
        throw new UnsupportedOperationException();
    }

    public String getPluginClassName() {
        return this.pluginClass.getCanonicalName();
    }

    public String getVersion() {
        return this.buildInfo.getVersion();
    }

    public String toString() {
        return String.format("BuiltInPluginDescriptor(%s %s)", this.getPluginId(), this.getPluginClassName());
    }

    @Generated
    public BuiltInPluginDescriptor(String pluginId, BuildInfo buildInfo, Class<? extends Plugin> pluginClass, Path sourcePath) {
        this.pluginId = pluginId;
        this.buildInfo = buildInfo;
        this.pluginClass = pluginClass;
        this.sourcePath = sourcePath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuiltInPluginDescriptor)) {
            return false;
        }
        BuiltInPluginDescriptor other = (BuiltInPluginDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuiltInPluginDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }
}

