/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.problem.ResultOrProblems;

public class TupleIteratorSink
implements Sink {
    public static final SinkConstructor CONSTRUCTOR = eo -> ResultOrProblems.of((Object)new TupleIteratorSink());
    private final Iterator instance = new Iterator();

    public boolean accept(Tuple tuple) {
        return this.instance.buffer.offer(tuple);
    }

    public void finish() {
        this.instance.finish();
    }

    @Generated
    public Iterator getInstance() {
        return this.instance;
    }

    public class Iterator
    extends PeekingTupleIterator {
        private final ArrayBlockingQueue<Tuple> buffer = new ArrayBlockingQueue(100);
        private AtomicBoolean exhausted = new AtomicBoolean(false);

        protected Tuple get() {
            do {
                Tuple got;
                try {
                    got = this.buffer.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("unexpected interrupt");
                }
                if (got == null) continue;
                return got;
            } while (!this.exhausted.get());
            return null;
        }

        protected String getSource() {
            return "unknown";
        }

        public void finish() {
            this.exhausted.set(true);
        }
    }
}

