/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterProperties;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.bind.ParameterTemplate;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.model.ModelParameter;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WithMetadata;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;

public class PipelineModelParameter
extends ModelParameter {
    public static PipelineModelParameter create(String name, ParameterTemplate template) {
        Class<Expression> bindTo = ParameterProperties.getBindingClass(template.getProperties()).orElse(Expression.class);
        Parameter parameter = Parameter.required((String)name, bindTo);
        return new PipelineModelParameter(parameter, template);
    }

    public PipelineModelParameter(Parameter parameter, ParameterTemplate template) {
        super(parameter.withValidation((c, v) -> template.validate(c, v)), template);
    }

    public PipelineModelParameter withDefaultValue(BindingContext context, Object value) {
        Parameter newParam = this.getParameter().withNewDefaults((c, p) -> Collections.singletonList(c.bind(p, value.toString())));
        ParameterTemplate updatedTemplate = this.getTemplate();
        if (updatedTemplate.getProperties().isEmpty()) {
            updatedTemplate = updatedTemplate.withProperties(this.inferProperties(context, value));
        }
        return new PipelineModelParameter(newParam, updatedTemplate);
    }

    public Expression getExpression(BoundParameters bound) {
        Object value = bound.getValue(this.getName());
        if (value instanceof Expression || value == null) {
            return (Expression)value;
        }
        Object toParse = value.toString().trim();
        if (!(!(value instanceof String) || ((String)toParse).startsWith("'") && ((String)toParse).endsWith("'"))) {
            toParse = TokenTypes.quoteText((String)toParse);
        }
        if (value instanceof ResolvedBookmark) {
            Optional<RealizedExpression> realized = this.getUnboundExpression(bound);
            if (realized.flatMap(expr -> WithMetadata.find((Type)expr.getResultType(), Bookmark.class)).isPresent()) {
                return realized.get().getExpression();
            }
            ResolvedBookmark bookmark = (ResolvedBookmark)value;
            Optional<String> bookmarkTemplate = this.getTemplate().getProperty(ParameterProperties.BOOKMARK_TEMPLATE).map(property -> (String)property.getValue());
            toParse = bookmarkTemplate.isPresent() ? "bookmark('" + bookmarkTemplate.get() + "', { location: '" + bookmark.getId() + "'})" : "bookmark('" + bookmark.getId() + "')";
        }
        return ExpressionParser.INSTANCE.parse((String)toParse);
    }

    private Optional<RealizedExpression> getUnboundExpression(BoundParameters bound) {
        return bound.getUnbound().getOrDefault(this.getName(), Collections.emptyList()).stream().findFirst().map(x -> (RealizedExpression)bound.getContext().getRealizationContext().realizeConstant(x.toString()).orElse(null));
    }

    private Set<ParameterProperty> inferProperties(BindingContext context, Object defaultValue) {
        return (Set)context.getRealizationContext().realizeConstant(defaultValue.toString()).map(realized -> ParameterProperties.infer(realized)).orElse(Collections.emptySet());
    }

    public List<Problem> validateExpression(BoundParameters bound) {
        Object boundValue = bound.getValue(this.getName());
        Expression expression = this.getExpression(bound);
        if (boundValue != null && !boundValue.equals(expression)) {
            return bound.getContext().getRealizationContext().realizeConstant(expression.toSource()).composeProblems(Problems.foundWith((Object)this.getParameter(), (Problem[])new Problem[0])).getProblems();
        }
        return Collections.emptyList();
    }
}

