/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.bind.ParameterTemplate;
import nz.org.riskscape.engine.ini.IniFileParameterBuilder;
import nz.org.riskscape.engine.model.BaseModel2;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.engine.model.ModelParameter;
import nz.org.riskscape.engine.pipeline.BaseModelFramework;
import nz.org.riskscape.engine.pipeline.DefaultStepNamingPolicy;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineModelParameter;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.StringResource;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.StepNamingPolicy;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.util.ListUtils;

public class ParameterizedPipelineModelFramework
extends BaseModelFramework {
    private final Engine engine;
    private final JavaParameterSet<Params> buildParameterSet = JavaParameterSet.fromBindingClass(Params.class);

    public String getId() {
        return "pipeline";
    }

    public ResultOrProblems<Model> build(Project project, BoundParameters buildWith) {
        StringResource pipelineSource;
        Params params = (Params)this.buildParameterSet.bindToObject(buildWith).getBoundToObject();
        if (params.pipeline.isPresent() && params.location.isPresent()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ParamProblems.get().mutuallyExclusive("pipeline", "location")});
        }
        if (params.pipeline.isPresent()) {
            pipelineSource = new StringResource(project.getOutputBaseLocation(), params.pipeline.get());
        } else if (params.location.isPresent()) {
            try {
                pipelineSource = this.engine.getResourceFactory().load(params.location.get());
            }
            catch (RiskscapeIOException | ResourceLoadingException ex) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith(Parameter.class, (String)"location", (Problem[])new Problem[]{Problems.caught((Throwable)ex)})});
            }
        } else {
            return ResultOrProblems.failed((Problem[])new Problem[]{ParamProblems.oneOfTheseRequired((String[])new String[]{"pipeline", "location"})});
        }
        return this.parsePipelineDecl((Resource)pipelineSource).flatMap(arg_0 -> this.lambda$build$0(buildWith, (Resource)pipelineSource, arg_0));
    }

    private List<PipelineModelParameter> getPipelineParameters(PipelineDeclaration parsed, Map<String, List<?>> unbound, BindingContext context, ProblemSink problemSink) {
        IniFileParameterBuilder parameterBuilder = new IniFileParameterBuilder(context.getProject());
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Set tokens = parsed.findParameters().keySet();
        ArrayList<PipelineModelParameter> collected = new ArrayList<PipelineModelParameter>();
        for (ParameterToken parameterToken : tokens) {
            boolean noSpecifiedTemplate;
            String paramName = parameterToken.getToken().getValue();
            HashMap<String, List<String>> templateConfig = new HashMap<String, List<String>>();
            for (String key : IniFileParameterBuilder.KEYS) {
                List<?> values = unbound.get(this.definitionKey(paramName, key));
                if (values == null) continue;
                templateConfig.put(key, Lists.transform(values, v -> v.toString()));
            }
            boolean bl = noSpecifiedTemplate = !templateConfig.containsKey("template");
            if (noSpecifiedTemplate && context.getProject().getParameterTemplates().getOr(paramName).isPresent()) {
                templateConfig.put("template", List.of(paramName));
            }
            ParameterTemplate template = (ParameterTemplate)ProblemException.catching(() -> parameterBuilder.build(templateConfig)).map(t -> t, prob -> prob.withSeverity(Problem.Severity.WARNING)).addProblemsTo(problems).orElse((Object)ParameterTemplate.EMPTY);
            PipelineModelParameter parameter = PipelineModelParameter.create(paramName, template);
            List<?> values = unbound.get(this.definitionKey(paramName, new String[0]));
            if (values != null && values.size() > 0) {
                parameter = parameter.withDefaultValue(context, values.get(0));
                if (values.size() > 1) {
                    problems.add(ParamProblems.get().wrongNumberGiven(paramName, "1", values.size()).withSeverity(Problem.Severity.WARNING));
                }
            } else if (template.getDefaultValue().isPresent()) {
                parameter = parameter.withDefaultValue(context, template.getDefaultValue().get());
            }
            collected.add(parameter);
        }
        problems.forEach(problemSink);
        return collected;
    }

    private String definitionKey(String paramName, String ... subKeys) {
        return String.join((CharSequence)".", ListUtils.concat(Arrays.asList("param", paramName), Arrays.asList(subKeys)));
    }

    private ResultOrProblems<PipelineDeclaration> parsePipelineDecl(Resource pipelineSource) {
        return PipelineParser.parseParameterizedPipeline((Resource)pipelineSource).flatMap(decl -> decl.checkValid(decl.getStepNameFunction((StepNamingPolicy)new DefaultStepNamingPolicy())));
    }

    private ResultOrProblems<Model> build(BoundParameters builtWith, BindingContext context, PipelineDeclaration pipeline, Resource pipelineSource) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        List<PipelineModelParameter> parameters = this.getPipelineParameters(pipeline, builtWith.getExtraneous(), context, p -> problems.add(p));
        for (ModelParameter modelParameter : parameters) {
            if (!builtWith.getBoundTo().contains(modelParameter.getName())) continue;
            problems.add(GeneralProblems.get().nameAlreadyUsedBy(modelParameter.getName(), ModelFramework.class, Parameter.class));
        }
        ParameterSet parameterSet = new ParameterSet((Collection)Lists.transform(parameters, mp -> mp.getParameter()));
        Map<String, List<?>> map = this.getUnboundMap(builtWith.getExtraneous(), parameters);
        return this.buildWithIncompleteParameters(parameterSet.bind(context, map).withMoreProblems(problems), bound -> new PipelineModelImpl(builtWith, (BoundParameters)bound, pipeline, pipelineSource, parameters));
    }

    private Map<String, List<?>> getUnboundMap(Map<String, List<?>> extraneous, List<PipelineModelParameter> parameters) {
        HashMap unbound = Maps.newHashMap(extraneous);
        for (ModelParameter modelParameter : parameters) {
            unbound.remove(this.definitionKey(modelParameter.getName(), new String[0]));
            IniFileParameterBuilder.KEYS.forEach(key -> unbound.remove(this.definitionKey(param.getName(), (String)key)));
        }
        return unbound;
    }

    @Generated
    public ParameterizedPipelineModelFramework(Engine engine) {
        this.engine = engine;
    }

    @Generated
    public JavaParameterSet<Params> getBuildParameterSet() {
        return this.buildParameterSet;
    }

    private /* synthetic */ ResultOrProblems lambda$build$0(BoundParameters buildWith, Resource pipelineSource, PipelineDeclaration pipelineAst) {
        return this.build(buildWith, buildWith.getContext(), pipelineAst, pipelineSource);
    }

    public static class Params {
        @ParameterField
        public Optional<String> pipeline = Optional.empty();
        @ParameterField
        public Optional<URI> location = Optional.empty();
    }

    private class PipelineModelImpl
    extends BaseModel2 {
        private final PipelineDeclaration parameterizedPipeline;
        private PipelineDeclaration pipeline;

        PipelineModelImpl(BoundParameters typeParameters, BoundParameters bound, PipelineDeclaration parameterizedPipeline, Resource pipelineSource, List<PipelineModelParameter> parameters) {
            super((ModelFramework)ParameterizedPipelineModelFramework.this, typeParameters, bound, parameters);
            this.parameterizedPipeline = parameterizedPipeline;
        }

        public ResultOrProblems<RealizedPipeline> realize(ExecutionContext context) {
            return this.getBoundParameters().flatMap(boundParameters -> {
                Map toReplace = (Map)this.parameterizedPipeline.findParameters().keySet().stream().map(token -> token.getValue()).map(paramName -> Pair.of((Object)paramName, (Object)this.getExpression((String)paramName))).collect(Pair.toMap());
                ArrayList paramProblems = new ArrayList();
                toReplace.keySet().forEach(paramName -> paramProblems.addAll(this.validateParameter((String)paramName)));
                if (Problem.hasErrors(paramProblems)) {
                    return ResultOrProblems.failed(paramProblems);
                }
                this.pipeline = (PipelineDeclaration)this.parameterizedPipeline.replaceParameters(toReplace).get();
                RealizedPipeline realized = context.realize(this.pipeline);
                realized = realized.drainWarnings((Consumer)context.getProject().getProblemSink());
                return ResultOrProblems.of((Object)realized);
            });
        }

        private Expression getExpression(String parameterName) {
            return this.getModelParameter(parameterName).map(mp -> ((PipelineModelParameter)((Object)mp)).getExpression(this.getBoundParameters())).orElse(null);
        }

        private List<Problem> validateParameter(String parameterName) {
            return this.getModelParameter(parameterName).map(mp -> ((PipelineModelParameter)((Object)mp)).validateExpression(this.getBoundParameters())).orElse(Collections.emptyList());
        }

        @Generated
        public PipelineDeclaration getParameterizedPipeline() {
            return this.parameterizedPipeline;
        }

        @Generated
        public PipelineDeclaration getPipeline() {
            return this.pipeline;
        }
    }
}

