/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.pipeline.DefaultStepNamingPolicy;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.NullStep;
import nz.org.riskscape.engine.pipeline.Pipeline;
import nz.org.riskscape.engine.pipeline.PipelineBuilder;
import nz.org.riskscape.engine.pipeline.PipelineProblems;
import nz.org.riskscape.engine.pipeline.PipelineRealizer;
import nz.org.riskscape.engine.pipeline.PipelineSteps;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.RealizationInputImpl;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.pipeline.StepNamingPolicy;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.PipelineExpression;
import nz.org.riskscape.pipeline.ast.StepChain;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.pipeline.ast.StepDefinition;
import nz.org.riskscape.pipeline.ast.StepReference;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class DefaultPipelineRealizer
implements PipelineRealizer {
    public RealizedPipeline realize(ExecutionContext context, PipelineDeclaration pipeline) {
        return this.realize(RealizedPipeline.empty((ExecutionContext)context, (PipelineDeclaration)pipeline), pipeline);
    }

    public RealizedPipeline realize(RealizedPipeline addTo, PipelineDeclaration pipeline) {
        return this.realize(addTo, pipeline, addTo.getContext().getEngine().getPipelineSteps());
    }

    protected RealizedPipeline realize(RealizedPipeline addTo, PipelineDeclaration pipeline, PipelineSteps engineSteps) {
        DefaultStepNamingPolicy stepNamingPolicy = new DefaultStepNamingPolicy(addTo.getRealizedSteps().stream().map(RealizedStep::getName).collect(Collectors.toSet()));
        Instance instance = new Instance(addTo.getContext(), pipeline, engineSteps, pipeline.getStepNameFunction((StepNamingPolicy)stepNamingPolicy));
        instance.populateNodeMapFromRealized(addTo);
        instance.populateNodeMapFromAst();
        instance.ast.checkValid(instance.stepNamer).addProblemsTo(instance.problems);
        if (!Problem.hasErrors(instance.problems)) {
            instance.addEdges();
        }
        if (Problem.hasErrors(instance.problems)) {
            List<RealizedStep> dummySteps = instance.nodes.values().stream().map(node -> RealizedStep.named((String)node.stepName)).toList();
            return new RealizedPipeline(addTo.getContext(), pipeline, dummySteps, instance.problems);
        }
        return instance.traverseAndRealize(addTo);
    }

    static String dslToStep(String parameterName) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, parameterName);
    }

    static String stepToDsl(String parameterName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, parameterName);
    }

    @Generated
    public DefaultPipelineRealizer() {
    }

    private class Instance {
        private final ExecutionContext context;
        private final PipelineDeclaration ast;
        private final PipelineSteps availableSteps;
        private final Function<StepDeclaration, String> stepNamer;
        private final List<Problem> problems = new LinkedList<Problem>();
        private final Map<String, Node> nodes = new HashMap<String, Node>();

        void populateNodeMapFromRealized(RealizedPipeline addTo) {
            Node node;
            for (RealizedStep alreadyRealized : addTo.getRealizedSteps()) {
                node = new Node(alreadyRealized.getName(), alreadyRealized.getAst(), alreadyRealized.getImplementation());
                Node replaced = this.nodes.put(node.stepName, node);
                if (replaced != null) {
                    throw new AssertionError((Object)"Existing pipeline is invalid, has multiple steps with the same name");
                }
            }
            for (RealizedStep alreadyRealized : addTo.getRealizedSteps()) {
                node = this.nodes.get(alreadyRealized.getName());
                alreadyRealized.getDependencies().stream().map(depStep -> node.dependencies.add(this.nodes.get(depStep.getName())));
            }
            for (RealizedStep alreadyRealized : addTo.getRealizedSteps()) {
                node = this.nodes.get(alreadyRealized.getName());
                for (Node dependencyNode : node.dependencies) {
                    dependencyNode.dependents.add(node);
                }
            }
        }

        void populateNodeMapFromAst() {
            Iterator definitions = this.ast.stepDefinitionIterator();
            while (definitions.hasNext()) {
                StepDefinition toAdd = (StepDefinition)definitions.next();
                Node newNode = this.addDefinition(toAdd);
                this.nodes.put(newNode.stepName, newNode);
            }
        }

        boolean addEdges() {
            boolean valid = true;
            for (StepChain chain : this.ast.getChains()) {
                List steps = chain.getSteps();
                StepDeclaration lastStep = (StepDeclaration)steps.get(0);
                this.validateFirstStepInChain(steps);
                for (int i = 1; i < steps.size(); ++i) {
                    StepDeclaration nextStep = (StepDeclaration)steps.get(i);
                    Node from = this.findStep(lastStep);
                    Node to = this.findStep(nextStep);
                    if (from == null || to == null) {
                        lastStep = nextStep;
                        continue;
                    }
                    List<Problem> edgeErrors = from.addEdgeTo(to, nextStep.getNamedInput());
                    if (edgeErrors.size() > 0) {
                        this.problems.add(Problems.foundWith((Object)nextStep, edgeErrors));
                        valid = false;
                    }
                    lastStep = nextStep;
                }
            }
            return valid;
        }

        private Node findStep(StepDeclaration stepDecl) {
            Node lookingFor = this.nodes.get(this.stepNamer.apply(stepDecl));
            if (lookingFor == null) {
                this.problems.add(this.sourceError((PipelineExpression)stepDecl, Problem.error((ProblemCode)Pipeline.ProblemCodes.STEP_NAME_UNKNOWN, (Object[])new Object[]{stepDecl.getIdent(), this.nodes.keySet()})));
            }
            return lookingFor;
        }

        private void validateFirstStepInChain(List<StepDeclaration> steps) {
            StepDeclaration firstStep = steps.get(0);
            if (steps.size() == 1 && this.findStep(firstStep) != null && firstStep instanceof StepReference) {
                this.problems.add(this.sourceError((PipelineExpression)firstStep, Problem.error((ProblemCode)PipelineBuilder.ProblemCodes.UNUSED_STEP_REFERENCE, (Object[])new Object[]{firstStep.getIdent()})));
            }
            if (firstStep.getNamedInput().isPresent()) {
                this.problems.add(this.sourceError((PipelineExpression)firstStep, Problem.error((ProblemCode)PipelineBuilder.ProblemCodes.UNUSED_NAMED_INPUT, (Object[])new Object[]{firstStep.getIdent(), firstStep.getNamedInput().get()})));
            }
        }

        private Node addDefinition(StepDefinition toAdd) {
            Node existing;
            String name = this.stepNamer.apply((StepDeclaration)toAdd);
            ResultOrProblems stepOr = this.availableSteps.getOr(toAdd.getStepId());
            Step step = (Step)stepOr.orElse((Object)NullStep.INSTANCE);
            Node node = new Node(name, toAdd, step);
            if (stepOr.hasProblems()) {
                node.problems.add(Problems.foundWith((Object)toAdd, (List)stepOr.getProblems()));
            }
            if ((existing = this.nodes.get(name)) != null) {
                this.problems.add(this.sourceError((PipelineExpression)toAdd, Problem.error((ProblemCode)PipelineBuilder.ProblemCodes.STEP_REDEFINITION, (Object[])new Object[]{name, existing.definition, node.definition.getIdentToken()})));
                return existing;
            }
            return node;
        }

        private Token getLocation(PipelineExpression expr) {
            return expr.getBoundary().map(pair -> (Token)pair.getLeft()).orElse(Token.UNKNOWN_LOCATION);
        }

        private Problem sourceError(PipelineExpression expr, Problem ... children) {
            return Problems.foundWith((Object)this.getLocation(expr), (Problem[])children);
        }

        public RealizedPipeline traverseAndRealize(RealizedPipeline addTo) {
            LinkedList<Node> toVisit = new LinkedList<Node>();
            toVisit.addAll(this.nodes.values().stream().filter(node -> !node.isRealized(addTo)).toList());
            int skipCount = 0;
            RealizedPipeline ptr = addTo;
            while (!toVisit.isEmpty()) {
                assert (skipCount++ < toVisit.size());
                Node node2 = (Node)toVisit.removeFirst();
                if (!node2.isDependenciesAllRealized(ptr)) {
                    toVisit.addLast(node2);
                    continue;
                }
                skipCount = 0;
                if (!(ptr = this.realize(ptr, node2)).hasFailures()) continue;
                return ptr;
            }
            return ptr;
        }

        private RealizedPipeline realize(RealizedPipeline realized, Node node) {
            Map<Object, Object> parameterMap = !node.hasProblems() ? this.realizeParameters(node) : Map.of();
            RealizationInputImpl input = new RealizationInputImpl(realized, node.definition, node.stepName, node.getRealizedDependencies(realized), parameterMap);
            if (node.hasProblems()) {
                return realized.add(input.newPrototypeStep().withProblems(node.problems));
            }
            RealizedPipeline pipeline = node.implementation.realize((RealizationInput)input);
            if (!node.dependents.isEmpty() && pipeline.getStep(input.getName()).isEmpty()) {
                pipeline = pipeline.addProblems(new Problem[]{PipelineProblems.get().chainingFromStepWithNoOutput(input.getName(), node.dependents.stream().map(n -> n.stepName).toList())});
            }
            return pipeline;
        }

        private Map<String, List<?>> realizeParameters(Node node) {
            HashMap parameters = new HashMap();
            for (int i = 0; i < node.definition.getStepParameters().size(); ++i) {
                FunctionCall.Argument arg = (FunctionCall.Argument)node.definition.getStepParameters().get(i);
                Parameter parameter = node.getParameter(i);
                if (parameter == null) {
                    assert (node.hasProblems());
                    continue;
                }
                Expression argExpression = arg.getExpression();
                if (Expression.class.isAssignableFrom(parameter.getType())) {
                    parameters.put(parameter.getName(), Collections.singletonList(argExpression));
                    continue;
                }
                Object constant = this.context.getRealizationContext().getExpressionRealizer().realizeConstant(arg.getExpression()).map(re -> re.evaluate((Object)Tuple.EMPTY_TUPLE)).orElse(node.problems::addAll, null);
                if (constant == null) continue;
                if (constant instanceof List) {
                    List list = (List)constant;
                    parameters.put(parameter.getName(), list);
                    continue;
                }
                parameters.put(parameter.getName(), Arrays.asList(constant));
            }
            return parameters;
        }

        @Generated
        public Instance(ExecutionContext context, PipelineDeclaration ast, PipelineSteps availableSteps, Function<StepDeclaration, String> stepNamer) {
            this.context = context;
            this.ast = ast;
            this.availableSteps = availableSteps;
            this.stepNamer = stepNamer;
        }
    }

    private class Node {
        final String stepName;
        final StepDefinition definition;
        final Step implementation;
        final List<Node> dependencies = new LinkedList<Node>();
        final List<Node> dependents = new LinkedList<Node>();
        final List<Problem> problems = new LinkedList<Problem>();
        final Map<String, Node> namedInputs = new HashMap<String, Node>();

        List<Problem> addEdgeTo(Node to, Optional<String> namedInput) {
            Problem error = this.checkEdgeValid(to, namedInput);
            if (error != null) {
                return Arrays.asList(error);
            }
            this.dependents.add(to);
            to.dependencies.add(this);
            if (namedInput.isEmpty()) {
                namedInput = to.implementation.getDefaultInputName();
            }
            namedInput.map(name -> to.namedInputs.put((String)name, this));
            return Collections.emptyList();
        }

        private Problem checkEdgeValid(Node to, Optional<String> namedInput) {
            Optional<Node> existing;
            if (this.dependents.contains(to)) {
                return Problem.error((ProblemCode)Pipeline.ProblemCodes.EDGE_ALREADY_EXISTS, (Object[])new Object[]{this.stepName, to.stepName});
            }
            if (namedInput.isPresent()) {
                String name2 = namedInput.get();
                if (to.implementation.getInputNames().isEmpty()) {
                    return Problem.error((ProblemCode)Pipeline.ProblemCodes.NAMED_INPUT_NOT_ALLOWED, (Object[])new Object[]{to.implementation.getId(), name2, to.stepName});
                }
                if (!to.implementation.hasNamedInput(name2)) {
                    return PipelineProblems.get().namedInputUnknown(to.implementation, name2, to.implementation.getInputNames());
                }
            }
            if ((existing = to.getAlreadyChained(namedInput)).isPresent()) {
                String targetName = to.stepName + namedInput.map(name -> "." + name).orElse("");
                if (!namedInput.isPresent() && to.implementation.getDefaultInputName().isPresent()) {
                    String suggestedTarget = to.stepName + "." + to.getNamedInputAvailable().get();
                    return Problem.error((ProblemCode)Pipeline.ProblemCodes.DEFAULT_INPUT_ALREADY_CHAINED, (Object[])new Object[]{this.stepName + " -> " + targetName, suggestedTarget, to.stepName + "." + (String)to.implementation.getDefaultInputName().get(), existing.get().stepName});
                }
                return Problem.error((ProblemCode)Pipeline.ProblemCodes.INPUT_ALREADY_CHAINED, (Object[])new Object[]{this.stepName, targetName, existing.get().stepName});
            }
            return null;
        }

        Optional<Node> getAlreadyChained(Optional<String> namedInput) {
            Optional<Node> existing;
            if (!namedInput.isPresent()) {
                namedInput = this.implementation.getDefaultInputName();
            }
            if ((existing = namedInput.map(name -> this.namedInputs.get(name))).isPresent()) {
                return existing;
            }
            Range arity = this.implementation.getInputArity();
            if (arity.hasUpperBound() && ((Integer)arity.upperEndpoint()).intValue() == this.dependencies.size()) {
                assert (!this.dependencies.isEmpty()) : "dependencies are empty " + String.valueOf(this);
                return Optional.of(this.dependencies.get(0));
            }
            return Optional.empty();
        }

        Optional<String> getNamedInputAvailable() {
            ArrayList available = new ArrayList(this.implementation.getInputNames());
            available.removeAll(this.namedInputs.keySet());
            return available.size() > 0 ? Optional.of((String)available.get(0)) : Optional.empty();
        }

        boolean isRealized(RealizedPipeline pipeline) {
            return pipeline.getStep(this.stepName).isPresent();
        }

        boolean isDependenciesAllRealized(RealizedPipeline pipeline) {
            return this.dependencies.stream().allMatch(n -> n.isRealized(pipeline));
        }

        public Parameter getParameter(int index) {
            int humanIndex = index + 1;
            FunctionCall.Argument argument = (FunctionCall.Argument)this.definition.getStepParameters().get(index);
            String name = argument.getNameToken().map(t -> {
                if (t.type == TokenTypes.QUOTED_IDENTIFIER) {
                    return t.getValue();
                }
                return DefaultPipelineRealizer.dslToStep(t.getValue());
            }).orElse(null);
            boolean preceedingArgsKeyworded = this.definition.getStepParameters().subList(0, index).stream().anyMatch(FunctionCall.Argument::isKeywordArgument);
            if (name == null) {
                if (preceedingArgsKeyworded) {
                    this.problems.add(Problem.error((ProblemCode)PipelineBuilder.ProblemCodes.KEYWORD_REQUIRED, (Object[])new Object[]{humanIndex}));
                    return null;
                }
                if (index >= this.implementation.getParameterSet().size()) {
                    this.problems.add(ArgsProblems.get().wrongNumber(this.implementation.getParameterSet().size(), humanIndex));
                    return null;
                }
                name = ((Parameter)this.implementation.getParameterSet().toList().get(index)).getName();
            }
            try {
                return this.implementation.getParameterSet().get(name);
            }
            catch (IllegalArgumentException ex) {
                List available = this.implementation.getParameterSet().getDeclared().stream().map(Parameter::getName).map(DefaultPipelineRealizer::stepToDsl).collect(Collectors.toList());
                this.problems.add(Problem.error((ProblemCode)PipelineBuilder.ProblemCodes.STEP_PARAMETER_UNKNOWN, (Object[])new Object[]{name, available, this.implementation.getId()}));
                return null;
            }
        }

        public boolean hasProblems() {
            return !this.problems.isEmpty();
        }

        public List<RealizedStep> getRealizedDependencies(RealizedPipeline pipeline) {
            if (this.implementation.getInputNames().isEmpty()) {
                return this.dependencies.stream().map(node -> (RealizedStep)pipeline.getStep(node.stepName).get()).toList();
            }
            return this.implementation.getInputNames().stream().map(name -> this.namedInputs.get(name)).filter(node -> node != null).map(node -> (RealizedStep)pipeline.getStep(node.stepName).get()).toList();
        }

        @Generated
        public Node(String stepName, StepDefinition definition, Step implementation) {
            this.stepName = stepName;
            this.definition = definition;
            this.implementation = implementation;
        }
    }
}

