/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.DefaultBindingContext;
import nz.org.riskscape.engine.pipeline.DefaultPipelineRealizer;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.PipelineRealizer;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.util.FileUtils;
import nz.org.riskscape.engine.util.ParentingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultPipelineExecutor
implements PipelineExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPipelineExecutor.class);
    protected final Engine engine;
    private static final int DEFAULT_SINGLE_THREADED = 1;
    private int numThreads = 1;

    public ExecutionContext newExecutionContext(Project project) {
        return new Ctx(project);
    }

    public boolean isParallelizationEnabled() {
        return this.numThreads > 1;
    }

    @Generated
    public DefaultPipelineExecutor(Engine engine) {
        this.engine = engine;
    }

    @Generated
    public int getNumThreads() {
        return this.numThreads;
    }

    @Generated
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    private class Ctx
    implements ExecutionContext {
        private final Project project;
        private final Engine engine;
        private final Path tempDirectory;
        private final MetricRegistry metricRegistry = new MetricRegistry();
        private final BindingContext bindingContext;
        private final ExpressionRealizer expressionRealizer;

        Ctx(Project project) {
            this.project = project;
            this.engine = project.getEngine();
            try {
                this.tempDirectory = Files.createTempDirectory(this.engine.getTempDirectory(), "execution-context-", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            RealizationContext realizationContext = project.newRealizationContext();
            this.bindingContext = new DefaultBindingContext(project, realizationContext, this.tempDirectory);
            this.expressionRealizer = realizationContext.getExpressionRealizer();
        }

        public PipelineExecutor getPipelineExecutor() {
            return DefaultPipelineExecutor.this;
        }

        public ExecutionContext createNestedContext(String name) {
            Ctx child = new Ctx(this.project);
            child.metricRegistry.addListener((MetricRegistryListener)new ParentingListener(this.metricRegistry, name + "."));
            return child;
        }

        public void close() {
            try {
                if (Files.exists(this.tempDirectory, new LinkOption[0])) {
                    FileUtils.removeDirectory((Path)this.tempDirectory);
                }
            }
            catch (IOException e) {
                log.warn("could not delete execution context temp directory", (Throwable)e);
            }
        }

        public PipelineRealizer getPipelineRealizer() {
            return new DefaultPipelineRealizer();
        }

        @Generated
        public Ctx(Project project, Engine engine, Path tempDirectory, BindingContext bindingContext, ExpressionRealizer expressionRealizer) {
            this.project = project;
            this.engine = engine;
            this.tempDirectory = tempDirectory;
            this.bindingContext = bindingContext;
            this.expressionRealizer = expressionRealizer;
        }

        @Generated
        public Project getProject() {
            return this.project;
        }

        @Generated
        public Engine getEngine() {
            return this.engine;
        }

        @Generated
        public Path getTempDirectory() {
            return this.tempDirectory;
        }

        @Generated
        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }

        @Generated
        public BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @Generated
        public ExpressionRealizer getExpressionRealizer() {
            return this.expressionRealizer;
        }
    }
}

