/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseModelFramework
implements ModelFramework {
    private List<Problem> ignoreIncompleteParameters(BoundParameters bound) {
        ArrayList<Problem> invalidParms = new ArrayList<Problem>();
        Problem toIgnore = GeneralProblems.get().required((Object)"");
        for (Problem problem : bound.getValidationProblems()) {
            if (toIgnore.getCode().equals(problem.getCode())) continue;
            invalidParms.add(problem);
        }
        return invalidParms;
    }

    protected ResultOrProblems<Model> buildWithIncompleteParameters(BoundParameters modelParameters, Function<BoundParameters, Model> modelBuilder) {
        List<Problem> problems = this.ignoreIncompleteParameters(modelParameters);
        if (!modelParameters.getExtraneous().isEmpty()) {
            problems.add(ParamProblems.get().ignoredWithHints(modelParameters.getExtraneous().keySet(), modelParameters.getBoundTo().getDeclared().stream().map(Parameter::getName).collect(Collectors.toSet())));
        }
        if (!Problem.hasErrors(problems)) {
            return ResultOrProblems.of((Object)modelBuilder.apply(modelParameters)).withMoreProblems(problems);
        }
        return ResultOrProblems.failed(problems);
    }
}

