/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;

public class StructFlattener {
    private static final int FIRST_DOUBLE_DIGIT = 10;
    private static final Pattern INDEXED_KEY_PATTERN = Pattern.compile("(\\d+)$");
    public static final String SEPARATOR = ".";

    public List<StructMapping> flatten(Struct struct) {
        return this.flatten(struct, new DotSeparatedNamer());
    }

    public List<StructMapping> flatten(Struct struct, Namer namer) {
        ArrayList<StructMapping> mappings = new ArrayList<StructMapping>();
        this.flatten(mappings, struct, new ArrayList<Struct.StructMember>(), namer);
        return mappings;
    }

    private void flatten(List<StructMapping> mappings, Struct struct, List<Struct.StructMember> segments, Namer namer) {
        struct.getMembers().forEach(member -> {
            boolean nullable = Nullable.is((Type)member.getType());
            Type type = Nullable.strip((Type)member.getType());
            Optional sType = type.find(Struct.class);
            if (sType.isPresent()) {
                ArrayList mySegments = Lists.newArrayList((Iterable)segments);
                mySegments.add(member);
                this.flatten(mappings, (Struct)sType.get(), mySegments, namer);
            } else {
                ArrayList mySegments = Lists.newArrayList((Iterable)segments);
                mySegments.add(member);
                mappings.add(new StructMapping(namer.name(mySegments), Nullable.ifTrue((boolean)nullable, (Type)type), mySegments));
            }
        });
    }

    @Deprecated
    public void shortenIfNecessary(List<StructMapping> mappings, int maxLength) {
        mappings.stream().filter(m -> m.getKey().length() > maxLength).forEach(m -> {
            StringBuilder sb = new StringBuilder();
            List<Struct.StructMember> segments = m.getSegments();
            for (int i = 0; i < segments.size() - 1; ++i) {
                sb.append(this.shortenKey(segments.get(i).getKey())).append(SEPARATOR);
            }
            sb.append(segments.get(segments.size() - 1).getKey());
            String key = sb.toString();
            if (key.length() > maxLength) {
                key = key.substring(0, maxLength);
            }
            m.setKey(key);
        });
        for (StructMapping entry : mappings) {
            List dupes = mappings.stream().filter(rhs -> rhs.getKey().equals(entry.getKey())).collect(Collectors.toList());
            if (dupes.size() <= 1) continue;
            if (dupes.size() > 10) {
                throw new IllegalArgumentException("too many duplicated field names after truncation, giving up");
            }
            int counter = 0;
            for (StructMapping dupe : dupes) {
                String shortKey = dupe.getKey();
                if (shortKey.length() >= maxLength) {
                    shortKey = shortKey.substring(0, maxLength - 1);
                }
                dupe.setKey(shortKey + Integer.toString(counter));
                ++counter;
            }
        }
    }

    String shortenKey(String key) {
        Matcher m = INDEXED_KEY_PATTERN.matcher(key);
        if (m.find()) {
            String index = m.group();
            if (key.equals(index)) {
                return key;
            }
            return key.substring(0, 1) + index;
        }
        return key.substring(0, 1);
    }

    public static class DotSeparatedNamer
    implements Namer {
        @Override
        public String name(List<Struct.StructMember> segments) {
            return segments.stream().map(s -> s.getKey()).collect(Collectors.joining(StructFlattener.SEPARATOR));
        }
    }

    public static interface Namer {
        public String name(List<Struct.StructMember> var1);
    }

    public static class StructMapping {
        private final Type type;
        private final List<Struct.StructMember> segments;
        private final StructMemberAccessExpression accessExpression;
        private String key;

        public StructMapping(String key, Type type, List<Struct.StructMember> segments) {
            this.key = key;
            this.type = type;
            this.segments = segments;
            this.accessExpression = new StructMemberAccessExpression(false, segments);
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public List<Struct.StructMember> getSegments() {
            return this.segments;
        }

        @Generated
        public StructMemberAccessExpression getAccessExpression() {
            return this.accessExpression;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        private void setKey(String key) {
            this.key = key;
        }
    }

    public static class LastMemberNamer
    implements Namer {
        private static final Pattern ORDINAL_PATTERN = Pattern.compile("(.+)_([0-9]+)");
        private final List<String> taken = new ArrayList<String>();

        @Override
        public String name(List<Struct.StructMember> segments) {
            Object name = segments.get(segments.size() - 1).getKey();
            while (this.taken.contains(name)) {
                int ord;
                Matcher matcher = ORDINAL_PATTERN.matcher((CharSequence)name);
                if (matcher.find()) {
                    ord = Integer.parseInt(matcher.group(2)) + 1;
                    name = matcher.group(1);
                } else {
                    ord = 1;
                }
                name = (String)name + "_" + ord;
            }
            this.taken.add((String)name);
            return name;
        }
    }
}

