/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.ShapeFileNullMapper;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.MultiGeom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.StandardCodes;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.ShapefileWriting;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.referencing.wkt.Formattable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileWriter2
extends RiskscapeWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShapefileWriter2.class);
    private static final Pattern ORDINAL_PATTERN = Pattern.compile("(.+)_([0-9]+)");
    private final WKTWriter writer = new WKTWriter();
    private static final short SHP_RECORD_SEPARATOR_BYTES = 8;
    private static final short SHP_NULL_GEOM_BYTES = 4;
    private static final int MAX_COLUMN_NAME_LENGTH = 10;
    private final SRIDSet sridSet;
    private final boolean prjSingleLine;
    final ShpFiles shpFiles;
    final DbaseFileWriter dbfWriter;
    final DbaseFileHeader dbfHeader;
    final ShapefileWriter shpWriter;
    protected TimeZone timeZone = TimeZone.getDefault();
    protected Charset charset = Charset.defaultCharset();
    private int recordsWritten = 0;
    final int dbfRowLength;
    private final Object[] dbfRow;
    private final LinkedList<WritePosition> arrayStack = new LinkedList();
    int geomIndex = -1;
    private final Boolean[] toStringThese;
    private Envelope bounds = new Envelope();
    private ShapeType shapeType;
    private int shapefileLength;
    final FileChannel dbfChannel;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private ShapeHandler handler;
    private StorageFile shpStorageFile;
    private StorageFile dbfStorageFile;
    private StorageFile shxStorageFile;
    private StorageFile prjStorageFile;
    private StorageFile cpgStorageFile;
    private int srid = -1;
    private AxisSwapper axisSwapper = null;
    private Type geomType;
    private final URI storedAt;
    private final ProblemSink problemSink;
    private boolean loggedReprojection = false;
    ShapeFileNullMapper nullMapper = new ShapeFileNullMapper();

    public ShapefileWriter2(File shpPath, Struct type, SRIDSet sridSet, ProblemSink problemSink) throws IOException {
        this(shpPath, type, sridSet, problemSink, false);
    }

    public ShapefileWriter2(File shpPath, Struct type, SRIDSet sridSet, ProblemSink problemSink, boolean prjSingleLine) throws IOException {
        this.sridSet = sridSet;
        this.problemSink = problemSink;
        this.storedAt = shpPath.toURI();
        this.shpFiles = new ShpFiles(shpPath);
        this.prjSingleLine = prjSingleLine;
        this.shpStorageFile = this.shpFiles.getStorageFile(ShpFileType.SHP);
        this.dbfStorageFile = this.shpFiles.getStorageFile(ShpFileType.DBF);
        this.shxStorageFile = this.shpFiles.getStorageFile(ShpFileType.SHX);
        this.prjStorageFile = this.shpFiles.getStorageFile(ShpFileType.PRJ);
        this.cpgStorageFile = this.shpFiles.getStorageFile(ShpFileType.CPG);
        this.dbfChannel = this.dbfStorageFile.getWriteChannel();
        this.shpWriter = this.createShpWriter();
        this.dbfHeader = this.createDbaseHeader();
        LinkedList<Boolean> toStringList = new LinkedList<Boolean>();
        LinkedList<String> colsSoFar = new LinkedList<String>();
        this.dbfRowLength = this.calculateDbfRowLength(0, type, toStringList, colsSoFar);
        this.dbfRow = new Object[this.dbfRowLength];
        if (this.geomIndex == -1) {
            throw new RiskscapeException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{type}));
        }
        this.dbfWriter = this.createDbaseWriter();
        this.toStringThese = toStringList.toArray(new Boolean[toStringList.size()]);
    }

    protected DbaseFileHeader createDbaseHeader() {
        return new DbaseFileHeader();
    }

    protected ShapefileWriter createShpWriter() throws IOException {
        return new ShapefileWriter(this.shpStorageFile.getWriteChannel(), this.shxStorageFile.getWriteChannel());
    }

    protected DbaseFileWriter createDbaseWriter() throws IOException {
        return new DbaseFileWriter(this.dbfHeader, (WritableByteChannel)this.dbfChannel, this.charset, this.timeZone);
    }

    private int calculateDbfRowLength(int startAt, Struct type, List<Boolean> toStringList, List<String> namesSoFar) {
        int counter = 0;
        for (Struct.StructMember member : type.getMembers()) {
            Struct childStruct = member.getType().findAllowNull(Struct.class).orElse(null);
            if (childStruct != null) {
                counter += this.calculateDbfRowLength(startAt + counter, childStruct, toStringList, namesSoFar);
                continue;
            }
            if (this.geomIndex == -1 && member.getType().findAllowNull(Geom.class).isPresent()) {
                this.geomIndex = startAt + counter;
                this.geomType = Nullable.strip((Type)member.getType());
                continue;
            }
            try {
                toStringList.add(this.addColumn(member, namesSoFar));
            }
            catch (DbaseFileException e) {
                throw new RuntimeException(e);
            }
            ++counter;
        }
        return counter;
    }

    private boolean addColumn(Struct.StructMember member, List<String> namesSoFar) throws DbaseFileException {
        Type type = Nullable.strip((Type)member.getType());
        Class colType = type.internalType();
        String rawColName = member.getKey();
        String colName = this.adjust(rawColName, namesSoFar);
        namesSoFar.add(colName);
        return ShapefileWriting.addDbfHeader(colType, colName, this.dbfHeader);
    }

    String adjust(String colName, List<String> namesSoFar) {
        if (((String)colName).equals("the_geom")) {
            colName = "the_geom_1";
        }
        if (((String)(colName = ((String)colName).replaceAll("[^a-zA-Z0-9_]", "_"))).length() > 10) {
            colName = ((String)colName).substring(0, 10);
        }
        while (namesSoFar.contains(colName)) {
            int ord;
            Matcher matcher = ORDINAL_PATTERN.matcher((CharSequence)colName);
            if (matcher.find()) {
                ord = Integer.parseInt(matcher.group(2)) + 1;
                colName = matcher.group(1);
            } else {
                ord = 1;
            }
            String ordinatedColName = (String)colName + "_" + ord;
            int delta = ordinatedColName.length() - 10;
            if (delta > 0) {
                colName = ((String)colName).substring(0, ((String)colName).length() - delta) + "_" + ord;
                continue;
            }
            colName = ordinatedColName;
        }
        return colName;
    }

    public void close() throws IOException {
        if (this.shapeType == null) {
            this.shapeType = this.shapeTypeFrom(this.geomType, ShapeType.POINT);
        }
        this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.recordsWritten, this.shapefileLength);
        this.dbfHeader.setNumRecords(this.recordsWritten);
        this.dbfChannel.position(0L);
        this.dbfHeader.writeHeader((WritableByteChannel)this.dbfChannel);
        this.shpWriter.close();
        this.dbfWriter.close();
        this.shpStorageFile.replaceOriginal();
        this.shxStorageFile.replaceOriginal();
        this.dbfStorageFile.replaceOriginal();
        this.writeCpg();
        try {
            this.writePrj();
        }
        catch (Exception e) {
            log.error("Failed to write prj file {}", (Object)this.prjStorageFile, (Object)e);
        }
    }

    private void writePrj() throws IOException {
        int sridToUse;
        int n = sridToUse = this.axisSwapper == null ? this.srid : this.sridSet.get(this.axisSwapper.getNewCrs());
        if (sridToUse == -1) {
            sridToUse = this.sridSet.get(SRIDSet.EPSG4326_LONLAT);
        }
        if (sridToUse > 0) {
            CoordinateReferenceSystem crs = this.sridSet.get(sridToUse);
            FileChannel channel = this.prjStorageFile.getWriteChannel();
            Formattable formattableCRS = (Formattable)crs;
            int indentation = this.prjSingleLine ? 0 : 2;
            String crsWKT = formattableCRS.toWKT(indentation);
            ByteBuffer bytes = ByteBuffer.wrap(crsWKT.getBytes());
            channel.write(bytes);
            channel.close();
            this.prjStorageFile.replaceOriginal();
        }
    }

    private void writeCpg() {
        try (FileChannel channel = this.cpgStorageFile.getWriteChannel();){
            channel.write(ByteBuffer.wrap(this.charset.name().getBytes()));
            this.cpgStorageFile.replaceOriginal();
        }
        catch (Exception e) {
            log.error("Failed to write cpg file {}", (Object)this.cpgStorageFile, (Object)e);
        }
    }

    public void write(Tuple value) {
        int rowIndex = 0;
        int iterIndex = -1;
        int dbfIndex = 0;
        Struct structType = value.getStruct();
        while (true) {
            if (rowIndex >= value.size()) {
                if (this.arrayStack.isEmpty()) break;
                WritePosition popped = this.arrayStack.removeLast();
                rowIndex = popped.rowIndex;
                value = popped.value;
                structType = popped.structType;
                continue;
            }
            Object attrValue = value.fetch(rowIndex);
            Type valueType = ((Struct.StructMember)structType.getMembers().get(rowIndex)).getType();
            ++rowIndex;
            Optional nestedStruct = valueType.findAllowNull(Struct.class);
            if (nestedStruct.isPresent()) {
                Tuple child = (Tuple)attrValue;
                this.arrayStack.addLast(new WritePosition(rowIndex, value, structType));
                structType = (Struct)nestedStruct.get();
                rowIndex = 0;
                value = child == null ? new Tuple(structType) : child;
                continue;
            }
            if (++iterIndex == this.geomIndex) {
                this.writeGeom((Geometry)attrValue);
                continue;
            }
            Object toSet = (attrValue = this.nullMapper.mapValueIfNecessary(attrValue, valueType)) instanceof Geometry ? this.writer.write((Geometry)attrValue) : (this.toStringThese[dbfIndex] != false ? (attrValue == null ? null : attrValue.toString()) : attrValue);
            this.dbfRow[dbfIndex++] = toSet;
        }
        this.writeDbf();
        ++this.recordsWritten;
    }

    private void writeDbf() {
        try {
            this.dbfWriter.write(this.dbfRow);
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could not write to dbf file", (Exception)e);
        }
    }

    private Geometry reprojectToConsistentCrs(Geometry geom) {
        if (this.srid == -1 || geom.getSRID() == this.srid) {
            return geom;
        }
        if (!this.loggedReprojection && !this.sridSet.getReprojectionTransform(geom.getSRID(), this.srid).isIdentity()) {
            this.problemSink.log(GeometryProblems.get().crsMixtureReprojected((Object)this.storedAt, this.sridSet.get(this.srid)));
            this.loggedReprojection = true;
        }
        return this.sridSet.reproject(geom, this.srid);
    }

    private void writeGeom(Geometry geom) {
        Envelope env;
        if (geom == null) {
            try {
                if (this.recordsWritten == 0) {
                    this.shapeType = this.shapeTypeFrom(this.geomType);
                    this.handler = this.shapeType.getShapeHandler(this.geometryFactory);
                    this.shpWriter.writeHeaders(new Envelope(), ShapeType.POINT, 0, 0);
                }
                this.shapefileLength += 12;
                this.shpWriter.writeGeometry(null);
            }
            catch (IOException e) {
                throw new RiskscapeIOException("Could not write geometry to shp file", (Exception)e);
            }
            return;
        }
        if (this.shapeType == null) {
            int dims = JTSUtilities.guessCoorinateDims((Coordinate[])geom.getCoordinates());
            try {
                this.shapeType = JTSUtilities.getShapeType((Geometry)geom, (int)dims);
                this.handler = this.shapeType.getShapeHandler(this.geometryFactory);
            }
            catch (ShapefileException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.srid == -1) {
            this.srid = geom.getSRID();
            if (this.srid > 0) {
                this.axisSwapper = AxisSwapper.getForceXY(this.sridSet.get(this.srid), this.getStoredAt(), this.problemSink).orElse(null);
            }
        }
        geom = this.reprojectToConsistentCrs(geom);
        if (this.axisSwapper != null) {
            geom = this.axisSwapper.swapAxis(geom);
        }
        if (!(env = geom.getEnvelopeInternal()).isNull()) {
            this.bounds.expandToInclude(env);
        }
        if (geom instanceof LineString) {
            geom = geom.getFactory().createMultiLineString(new LineString[]{(LineString)geom});
        } else if (geom instanceof Polygon) {
            geom = geom.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geom});
        }
        this.shapefileLength += this.handler.getLength((Object)geom) + 8;
        try {
            this.shpWriter.writeGeometry(geom);
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could not write geometry to shp file", (Exception)e);
        }
    }

    private ShapeType shapeTypeFrom(Type type) throws ShapefileException {
        return this.shapeTypeFrom(type, ShapeType.UNDEFINED);
    }

    private ShapeType shapeTypeFrom(Type type, ShapeType orElse) throws ShapefileException {
        Optional<Class> multiGeom = type.find(MultiGeom.class).map(MultiGeom::internalType);
        if (multiGeom.isPresent()) {
            return JTSUtilities.getShapeType((Class)multiGeom.get());
        }
        Optional<Class> geometryType = type.find(GeomType.class).map(Type::internalType);
        if (geometryType.isPresent()) {
            return JTSUtilities.getShapeType((Class)geometryType.get());
        }
        return orElse;
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }

    private static final class WritePosition {
        private final int rowIndex;
        private final Tuple value;
        private final Struct structType;

        @Generated
        public WritePosition(int rowIndex, Tuple value, Struct structType) {
            this.rowIndex = rowIndex;
            this.value = value;
            this.structType = structType;
        }

        @Generated
        public int getRowIndex() {
            return this.rowIndex;
        }

        @Generated
        public Tuple getValue() {
            return this.value;
        }

        @Generated
        public Struct getStructType() {
            return this.structType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WritePosition)) {
                return false;
            }
            WritePosition other = (WritePosition)o;
            if (this.getRowIndex() != other.getRowIndex()) {
                return false;
            }
            Tuple this$value = this.getValue();
            Tuple other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Struct this$structType = this.getStructType();
            Struct other$structType = other.getStructType();
            return !(this$structType == null ? other$structType != null : !this$structType.equals(other$structType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowIndex();
            Tuple $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Struct $structType = this.getStructType();
            result = result * 59 + ($structType == null ? 43 : $structType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ShapefileWriter2.WritePosition(rowIndex=" + this.getRowIndex() + ", value=" + String.valueOf(this.getValue()) + ", structType=" + String.valueOf(this.getStructType()) + ")";
        }
    }
}

