/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.relation.LockDefeater;
import nz.org.riskscape.engine.output.AbstractDataStoreWriter;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.ShapeFileNullMapper;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ProblemSink;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileWriter
extends AbstractDataStoreWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShapefileWriter.class);
    public static final ShapefileDataStoreFactory FACTORY = new ShapefileDataStoreFactory();
    public static final int MAX_FIELD_LENGTH = 10;
    private static final LockDefeater LOCK_DEFEATER = new LockDefeater("ShapefileWriter_geotools");
    private final ShapeFileNullMapper nullMapper = new ShapeFileNullMapper();
    private final ProblemSink problemSink;

    public ShapefileWriter(File outfile, SRIDSet sridSet, ProblemSink problemSink) throws IOException {
        super(outfile, sridSet, FACTORY.createNewDataStore((Map)ImmutableMap.of((Object)"url", (Object)outfile.toURI().toURL(), (Object)"create spatial index", (Object)Boolean.TRUE)));
        this.problemSink = problemSink;
    }

    @Override
    public void close() throws IOException {
        LOCK_DEFEATER.call("close datastore", () -> {
            super.close();
            return true;
        });
    }

    @Override
    protected int getAttrNameMaxLength() {
        return 10;
    }

    @Override
    protected CoordinateReferenceSystem outputCrs(CoordinateReferenceSystem crs) {
        this.axisSwapper = AxisSwapper.getForceXY(crs, this.getStoredAt(), this.problemSink).orElse(null);
        return super.outputCrs(this.axisSwapper == null ? crs : this.axisSwapper.getNewCrs());
    }

    @Override
    protected void setupCrsAndGeoType(Tuple value) throws IOException {
        if (this.setup) {
            return;
        }
        LOCK_DEFEATER.call("setup CRS and geom type", () -> {
            super.setupCrsAndGeoType(value);
            return true;
        });
        List nullables = this.mappings.stream().filter(m -> Nullable.is((Type)m.getType())).map(m -> m.getKey()).collect(Collectors.toList());
        if (!nullables.isEmpty()) {
            log.warn("Entries in {} will contain mapped values should the actual value be null", nullables);
        }
    }

    @Override
    protected Object mapValueIfNecessary(Object value, Type type) {
        return this.nullMapper.mapValueIfNecessary(value, type);
    }
}

