/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ShapeFileNullMapper {
    public static final String NULL_VALUE_TEXT = "";
    public static final Number NULL_VALUE_NUMBER = -9999L;
    public static final Boolean NULL_VALUE_BOOLEAN = Boolean.FALSE;
    public static final Date NULL_VALUE_DATE = new Date(0L);
    public static final Geometry NULL_VALUE_GEOMETRY;
    private static final Set<Type> NULL_NUMBER_TYPES;
    private static final Set<Type> NULL_TEXT_TYPES;

    public Object mapValueIfNecessary(Object value, Type type) {
        if (value != null) {
            return value;
        }
        Type baseType = Nullable.unwrap((Type)type);
        if (baseType.equals(Types.GEOMETRY)) {
            return NULL_VALUE_GEOMETRY;
        }
        if (NULL_TEXT_TYPES.contains(baseType)) {
            return NULL_VALUE_TEXT;
        }
        if (NULL_NUMBER_TYPES.contains(baseType)) {
            return NULL_VALUE_NUMBER;
        }
        if (baseType.equals(Types.BOOLEAN)) {
            return Boolean.FALSE;
        }
        if (baseType.equals(Types.DATE)) {
            return NULL_VALUE_DATE;
        }
        return null;
    }

    static {
        GeometryFactory gf = new GeometryFactory();
        NULL_VALUE_GEOMETRY = gf.createPoint((CoordinateSequence)null);
        NULL_NUMBER_TYPES = Sets.newHashSet((Object[])new Type[]{Types.INTEGER, Types.FLOATING, Types.DECIMAL});
        NULL_TEXT_TYPES = Sets.newHashSet((Object[])new Type[]{Types.TEXT, Types.ANYTHING, Types.GEOMETRY});
    }
}

