/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.projection.FlattenProjection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class KmlWriter
extends RiskscapeWriter {
    public static final String KML_NAMESPACE = "http://www.opengis.net/kml/2.2";
    public static final List<String> KML_DATA_MEMBERS = Lists.newArrayList((Object[])new String[]{"name", "visibility", "open", "address", "phoneNumber", "description"});
    private final Projector flattenProjector;
    private final Struct.StructMember geometryMember;
    private final List<Struct.StructMember> dataMembers;
    private final List<Pair<String, Struct.StructMember>> extendedDataMembers;
    private final CreateHandle handle;
    private final SRIDSet sridSet;
    private URI storedAt = null;
    private Writer baseWriter;
    private XMLStreamWriter xmlWriter = null;

    public static ResultOrProblems<KmlWriter> of(Struct type, CreateHandle handle, Project project) {
        return ProblemException.catching(() -> {
            FlattenProjection flattener = new FlattenProjection(".");
            Projector flattenProjector = (Projector)flattener.getProjectionFunction(type).getOrThrow();
            Struct.StructMember geomMember = TupleUtils.findGeometryMember((Struct)flattenProjector.getProjectedType(), (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
            if (geomMember == null) {
                throw new ProblemException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{type}));
            }
            ArrayList<Struct.StructMember> dataMembers = new ArrayList<Struct.StructMember>();
            ArrayList<Pair<String, Struct.StructMember>> extendedDataMembers = new ArrayList<Pair<String, Struct.StructMember>>();
            ArrayList<String> usedMemberNames = new ArrayList<String>(KML_DATA_MEMBERS);
            usedMemberNames.add("Geometry");
            ArrayList<Struct.StructMember> members = new ArrayList<Struct.StructMember>(flattenProjector.getProjectedType().getMembers());
            members.remove(geomMember);
            for (String dataMember : KML_DATA_MEMBERS) {
                Struct.StructMember member = KmlWriter.findMember(dataMember, members);
                if (member == null || (dataMember.equals("visibility") || dataMember.equals("open")) && member.getType().getUnwrappedType() != Types.BOOLEAN) continue;
                dataMembers.add(member);
                members.remove(member);
            }
            for (Struct.StructMember member : members) {
                int i = 1;
                String name = member.getKey();
                while (usedMemberNames.contains(name)) {
                    name = String.format("%s-%d", member.getKey(), i++);
                }
                extendedDataMembers.add((Pair<String, Struct.StructMember>)Pair.of((Object)name, (Object)member));
            }
            return new KmlWriter(flattenProjector, geomMember, dataMembers, extendedDataMembers, handle, project.getSridSet());
        });
    }

    private static Struct.StructMember findMember(String named, List<Struct.StructMember> members) {
        return members.stream().filter(member -> member.getKey().equals(named)).findFirst().orElse(null);
    }

    private KmlWriter(Projector flattenProjector, Struct.StructMember geometryMember, List<Struct.StructMember> dataMembers, List<Pair<String, Struct.StructMember>> extendedDataMembers, CreateHandle handle, SRIDSet sridSet) {
        this.flattenProjector = flattenProjector;
        this.geometryMember = geometryMember;
        this.dataMembers = dataMembers;
        this.extendedDataMembers = extendedDataMembers;
        this.handle = handle;
        this.sridSet = sridSet;
        this.initWriter();
    }

    public void write(Tuple input) {
        Tuple flattened = (Tuple)this.flattenProjector.apply((Object)input);
        try {
            Geometry geom;
            this.xmlWriter.writeStartElement("Placemark");
            for (Struct.StructMember structMember : this.dataMembers) {
                Object value = flattened.fetch(structMember);
                if (value == null) continue;
                this.xmlWriter.writeStartElement(structMember.getKey());
                this.xmlWriter.writeCharacters(Objects.toString(value));
                this.xmlWriter.writeEndElement();
            }
            if (!this.extendedDataMembers.isEmpty()) {
                this.xmlWriter.writeStartElement("ExtendedData");
                this.xmlWriter.writeStartElement("SchemaData");
                this.xmlWriter.writeAttribute("schemaUrl", "#riskscape");
                for (Pair pair : this.extendedDataMembers) {
                    Struct.StructMember member = (Struct.StructMember)pair.getRight();
                    Object value = flattened.fetch(member);
                    if (value == null) continue;
                    if (member == this.geometryMember) {
                        value = this.sridSet.reproject((Geometry)value, this.sridSet.get(SRIDSet.EPSG4326_LONLAT));
                    }
                    this.xmlWriter.writeStartElement("SimpleData");
                    this.xmlWriter.writeAttribute("name", (String)pair.getLeft());
                    this.xmlWriter.writeCharacters(Objects.toString(value));
                    this.xmlWriter.writeEndElement();
                }
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndElement();
            }
            if ((geom = (Geometry)flattened.fetch(this.geometryMember)) != null) {
                this.writeGeometry(this.sridSet.reproject(geom, this.sridSet.get(SRIDSet.EPSG4326_LONLAT)));
            }
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    private void initWriter() {
        try {
            this.baseWriter = new OutputStreamWriter(this.handle.getOutputStream(), Charset.forName("UTF-8"));
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            this.xmlWriter = xmlOutputFactory.createXMLStreamWriter(this.baseWriter);
            this.xmlWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlWriter.setDefaultNamespace(KML_NAMESPACE);
            this.xmlWriter.writeStartElement("kml");
            this.xmlWriter.writeStartElement("Document");
            this.xmlWriter.writeAttribute("id", "root_doc");
            if (!this.extendedDataMembers.isEmpty()) {
                this.xmlWriter.writeStartElement("Schema");
                this.xmlWriter.writeAttribute("name", "riskscape");
                this.xmlWriter.writeAttribute("id", "riskscape");
                for (Pair<String, Struct.StructMember> extendedMember : this.extendedDataMembers) {
                    Struct.StructMember member = (Struct.StructMember)extendedMember.getRight();
                    if (member == this.geometryMember) continue;
                    Type memberType = Nullable.strip((Type)member.getType().getUnwrappedType());
                    String type = "string";
                    if (memberType == Types.INTEGER) {
                        type = "int";
                    } else if (memberType == Types.FLOATING) {
                        type = "double";
                    } else if (memberType == Types.BOOLEAN) {
                        type = "bool";
                    }
                    this.xmlWriter.writeStartElement("SimpleField");
                    this.xmlWriter.writeAttribute("name", (String)extendedMember.getLeft());
                    this.xmlWriter.writeAttribute("type", type);
                    this.xmlWriter.writeEndElement();
                }
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeStartElement("Folder");
        }
        catch (Exception e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    public void close() throws IOException {
        if (this.xmlWriter != null) {
            try {
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndDocument();
                this.xmlWriter.close();
                this.baseWriter.close();
            }
            catch (XMLStreamException e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
            this.storedAt = this.handle.store();
        }
    }

    private void writeGeometry(Geometry g) throws XMLStreamException {
        if (g instanceof Point) {
            this.writePoint((Point)g);
        } else if (g instanceof LinearRing) {
            this.writeLinearRing((LinearRing)g);
        } else if (g instanceof LineString) {
            this.writeLineString((LineString)g);
        } else if (g instanceof Polygon) {
            this.writePolygon((Polygon)g);
        } else if (g instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)g);
        } else {
            throw new IllegalArgumentException("Geometry type not supported: " + g.getGeometryType());
        }
    }

    private void writePoint(Point point) throws XMLStreamException {
        this.xmlWriter.writeStartElement("Point");
        this.writeCoordinates(point.getCoordinates());
        this.xmlWriter.writeEndElement();
    }

    private void writeLineString(LineString line) throws XMLStreamException {
        this.xmlWriter.writeStartElement("LineString");
        this.writeCoordinates(line.getCoordinates());
        this.xmlWriter.writeEndElement();
    }

    private void writeLinearRing(LinearRing ring) throws XMLStreamException {
        this.xmlWriter.writeStartElement("LinearRing");
        this.writeCoordinates(ring.getCoordinates());
        this.xmlWriter.writeEndElement();
    }

    private void writePolygon(Polygon poly) throws XMLStreamException {
        this.xmlWriter.writeStartElement("Polygon");
        this.xmlWriter.writeStartElement("outerBoundaryIs");
        this.writeLinearRing(poly.getExteriorRing());
        this.xmlWriter.writeEndElement();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.xmlWriter.writeStartElement("innerBoundaryIs");
            this.writeLinearRing(poly.getInteriorRingN(i));
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeGeometryCollection(GeometryCollection multi) throws XMLStreamException {
        this.xmlWriter.writeStartElement("MultiGeometry");
        for (int i = 0; i < multi.getNumGeometries(); ++i) {
            this.writeGeometry(multi.getGeometryN(i));
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeCoordinates(Coordinate[] coordinates) throws XMLStreamException {
        this.xmlWriter.writeStartElement("coordinates");
        String coordinateString = Arrays.stream(coordinates).map(c -> String.format("%f,%f", c.getX(), c.getY())).collect(Collectors.joining(" "));
        this.xmlWriter.writeCharacters(coordinateString);
        this.xmlWriter.writeEndElement();
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }
}

