/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.types.Struct;

public class JSONWriter
extends RiskscapeWriter {
    private final CreateHandle handle;
    private final OutputStreamWriter writer;
    private URI storedAt = null;

    public JSONWriter(CreateHandle handle) {
        this.handle = handle;
        this.writer = new OutputStreamWriter(handle.getOutputStream());
    }

    public void close() throws IOException {
        this.writer.close();
        this.storedAt = this.handle.store();
    }

    public void write(Tuple value) {
        org.json.JSONWriter jsonWriter = new org.json.JSONWriter((Appendable)this.writer);
        this.writeInternal(value, jsonWriter);
        try {
            this.writer.append('\n');
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeInternal(Tuple value, org.json.JSONWriter jsonWriter) {
        jsonWriter.object();
        for (Struct.StructMember entry : value.getStruct().getMembers()) {
            jsonWriter.key(entry.getKey());
            Object childValue = value.fetch(entry);
            if (childValue instanceof Tuple) {
                this.writeInternal((Tuple)childValue, jsonWriter);
                continue;
            }
            jsonWriter.value(childValue);
        }
        jsonWriter.endObject();
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }
}

