/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.coverage.GridTypedCoverage;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.output.BaseFormat;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.WriterConstructor;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.raster.VectorToRaster;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.PropertyAccess;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;

public class GeoTiffFormat
extends BaseFormat {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public GeoTiffFormat() {
        super("geotiff", "tif", "image/tiff");
    }

    public Class<? extends Format.FormatOptions> getWriterOptionsClass() {
        return Options.class;
    }

    public Optional<WriterConstructor> getWriterConstructor() {
        return Optional.of((context, type, handle, options) -> ProblemException.catching(() -> {
            Options opts = options.flatMap(o -> {
                if (o instanceof Options) {
                    Options opt = (Options)((Object)((Object)((Object)o)));
                    return Optional.of(opt);
                }
                return Optional.empty();
            }).orElse(null);
            if (opts == null) {
                throw new ProblemException((Problems)GeneralProblems.get().required((Object)"options"));
            }
            Builder builder = new Builder(opts, type, context.getExpressionRealizer(), context.getProject().getSridSet());
            return builder.build(handle, context.getProject().getProblemSink());
        }));
    }

    public ResultOrProblems<? extends Format.FormatOptions> buildOptions(Map<String, List<?>> paramMap, BindingContext context, Struct input) {
        ResultOrProblems built = super.buildOptions(paramMap, context, input);
        if (built.hasProblems()) {
            return built;
        }
        Options options = (Options)((Object)built.get());
        Builder builder = new Builder(options, input, context.getRealizationContext().getExpressionRealizer(), context.getProject().getSridSet());
        return ProblemException.catching(() -> {
            builder.validate();
            return options;
        }).composeProblems(Problems.foundWith((Object)ProblemPlaceholder.of(Format.FormatOptions.class, (String)this.getId()), (Problem[])new Problem[0]));
    }

    public List<String> getRequiredOptions(BindingContext context) {
        return Arrays.asList("grid-resolution", "bounds");
    }

    public static class Options
    extends Format.FormatOptions {
        @ParameterField
        Optional<Double> gridResolution = Optional.empty();
        @ParameterField
        Optional<Expression> bounds = Optional.empty();
        @ParameterField
        Optional<Expression> value = Optional.empty();
        @ParameterField
        Optional<Expression> geometry = Optional.empty();
        @ParameterField
        VectorToRaster.PixelStrategy pixelStatistic = VectorToRaster.PixelStrategy.MEAN;
        @ParameterField
        Optional<GridTypedCoverage> template = Optional.empty();
    }

    private static class Builder {
        Options opts;
        Struct input;
        ExpressionRealizer realizer;
        SRIDSet sridSet;

        public RealizedExpression getValueExpression() throws ProblemException {
            RealizedExpression valueExpr = (RealizedExpression)this.opts.value.map(value -> this.realizer.realize((Type)this.input, value)).orElseGet(() -> this.expressionToFirstOfType(false)).getOrThrow();
            if (!valueExpr.getResultType().isNumeric()) {
                throw new ProblemException((Problems)TypeProblems.get().requiresOneOf((Object)"value", List.of(Types.FLOATING, Types.INTEGER), valueExpr.getResultType()));
            }
            return valueExpr;
        }

        public RealizedExpression getGeometryExpression() throws ProblemException {
            RealizedExpression geomExpr = (RealizedExpression)this.opts.geometry.map(value -> this.realizer.realize((Type)this.input, value)).orElseGet(() -> this.expressionToFirstOfType(true)).getOrThrow();
            if (geomExpr.getResultType().findAllowNull(Geom.class).isEmpty()) {
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)"geometry", (Type)Types.GEOMETRY, geomExpr.getResultType()));
            }
            return geomExpr;
        }

        public CoordinateReferenceSystem getTargetCrs() throws ProblemException {
            if (this.opts.template.isPresent()) {
                return this.opts.template.get().getCoordinateReferenceSystem();
            }
            Type geomType = this.getGeometryExpression().getResultType();
            Referenced referenced = (Referenced)geomType.findAllowNull(Referenced.class).orElseThrow(() -> new ProblemException((Problems)GeometryProblems.get().notReferenced(geomType)));
            return referenced.getCrs();
        }

        public ReferencedEnvelope getBounds() throws ProblemException {
            if (this.opts.bounds.isPresent()) {
                CoordinateReferenceSystem targetCrs = this.getTargetCrs();
                Geometry boundsGeom = (Geometry)this.realizer.realizeConstant(this.opts.bounds.get()).flatMap(re -> {
                    if (re.getResultType().findAllowNull(Geom.class).isEmpty()) {
                        return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().mismatch((Object)"bounds", (Type)Types.GEOMETRY, re.getResultType())});
                    }
                    return ResultOrProblems.of((Object)((Geometry)re.evaluate((Object)Tuple.EMPTY_TUPLE)));
                }).map(bounds -> this.sridSet.reproject(bounds, this.sridSet.get(targetCrs))).getOrThrow();
                return new ReferencedEnvelope(boundsGeom.getEnvelopeInternal(), targetCrs);
            }
            if (this.opts.template.isPresent()) {
                return this.opts.template.get().getEnvelope().get();
            }
            throw new ProblemException((Problems)GeneralProblems.required((String)"bounds", Parameter.class));
        }

        public double getScale() throws ProblemException {
            if (this.opts.gridResolution.isPresent()) {
                return 1.0 / GeometryUtils.toCrsUnits((double)this.opts.gridResolution.get(), (CoordinateReferenceSystem)this.getTargetCrs());
            }
            if (this.opts.template.isPresent()) {
                GridEnvelope2D range = this.opts.template.get().getCoverage().getGridGeometry().getGridRange2D();
                ReferencedEnvelope templateBounds = this.opts.template.get().getEnvelope().get();
                double gridResolution = VectorToRaster.getHeightCrsUnits(templateBounds) / (double)range.height;
                return 1.0 / gridResolution;
            }
            throw new ProblemException((Problems)GeneralProblems.required((String)"grid-resolution", Parameter.class));
        }

        public void validate() throws ProblemException {
            this.getValueExpression();
            this.getGeometryExpression();
            VectorToRaster.getDimensions(this.getBounds(), this.getScale()).map(d -> d, p -> p.withChildren(new Problems[]{PROBLEMS.dimensionsTip()})).getOrThrow();
        }

        public Writer build(CreateHandle handle, ProblemSink problemSink) throws ProblemException {
            this.validate();
            RealizedExpression valueExpr = this.getValueExpression();
            RealizedExpression geomExpr = this.getGeometryExpression();
            VectorToRaster v2r = new VectorToRaster();
            v2r.initialize(this.getBounds(), this.getScale(), this.opts.pixelStatistic);
            int srid = this.sridSet.get(this.getTargetCrs());
            return new Writer(t -> (Number)valueExpr.evaluate(t), t -> {
                Geometry geom = (Geometry)geomExpr.evaluate(t);
                if (geom == null) {
                    return geom;
                }
                return this.sridSet.reproject(geom, srid);
            }, v2r, handle, problemSink);
        }

        private ResultOrProblems<RealizedExpression> expressionToFirstOfType(boolean isGeometry) {
            List<String> members = this.findSegmentsToFirstMemberOfType(this.input, isGeometry);
            if (members.isEmpty()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().structMustHaveMemberType((Type)(isGeometry ? Types.GEOMETRY : Types.FLOATING), this.input)});
            }
            return this.realizer.realize((Type)this.input, (Expression)PropertyAccess.of(members));
        }

        private List<String> findSegmentsToFirstMemberOfType(Struct struct, boolean isGeometry) {
            for (Struct.StructMember member : struct.getMembers()) {
                List<String> nested;
                boolean hasType;
                boolean bl = hasType = isGeometry ? member.getType().findAllowNull(Geom.class).isPresent() : member.getType().isNumeric();
                if (hasType) {
                    ArrayList<String> found = new ArrayList<String>();
                    found.add(member.getKey());
                    return found;
                }
                Optional structMember = member.getType().findAllowNull(Struct.class);
                if (!structMember.isPresent() || (nested = this.findSegmentsToFirstMemberOfType((Struct)structMember.get(), isGeometry)).isEmpty()) continue;
                nested.add(0, member.getKey());
                return nested;
            }
            return Collections.emptyList();
        }

        @Generated
        public Builder(Options opts, Struct input, ExpressionRealizer realizer, SRIDSet sridSet) {
            this.opts = opts;
            this.input = input;
            this.realizer = realizer;
            this.sridSet = sridSet;
        }
    }

    private static class Writer
    extends RiskscapeWriter {
        private final Function<Tuple, Number> valueExtractor;
        private final Function<Tuple, Geometry> geometryExtractor;
        private final VectorToRaster v2r;
        private final CreateHandle handle;
        private final ProblemSink problemSink;
        private int skippedOutOfBounds = 0;
        private int skippedNullOrNaN = 0;
        private URI storedAt = null;

        public void write(Tuple value) {
            VectorToRaster.DrawFeatureResult drawResult = this.v2r.drawFeature(this.valueExtractor.apply(value), this.geometryExtractor.apply(value));
            if (drawResult == VectorToRaster.DrawFeatureResult.OUT_OF_BOUNDS) {
                ++this.skippedOutOfBounds;
            } else if (drawResult == VectorToRaster.DrawFeatureResult.SKIPPED_NO_VALUE_OR_GEOMETRY) {
                ++this.skippedNullOrNaN;
            }
        }

        public void close() throws IOException {
            GridCoverage2D coverage = this.v2r.constructCoverage("layer");
            GeoTiffWriter writer = new GeoTiffWriter((Object)this.handle.getOutputStream());
            writer.write((GridCoverage)coverage, null);
            writer.dispose();
            this.storedAt = this.handle.store();
            if (this.skippedOutOfBounds > 0) {
                this.problemSink.accept(PROBLEMS.skippedFeaturesOutOfBounds(this.skippedOutOfBounds, this.storedAt));
            }
            if (this.skippedNullOrNaN > 0) {
                this.problemSink.accept(PROBLEMS.skippedFeaturesNullOrNan(this.skippedNullOrNaN, this.storedAt));
            }
        }

        @Generated
        public Writer(Function<Tuple, Number> valueExtractor, Function<Tuple, Geometry> geometryExtractor, VectorToRaster v2r, CreateHandle handle, ProblemSink problemSink) {
            this.valueExtractor = valueExtractor;
            this.geometryExtractor = geometryExtractor;
            this.v2r = v2r;
            this.handle = handle;
            this.problemSink = problemSink;
        }

        @Generated
        public URI getStoredAt() {
            return this.storedAt;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem dimensionsTip();

        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem skippedFeaturesOutOfBounds(int var1, URI var2);

        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem skippedFeaturesNullOrNan(int var1, URI var2);
    }
}

