/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Formatter;
import lombok.Generated;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.projection.FlattenProjection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class GeoJSONWriter
extends RiskscapeWriter {
    private final Projector flattenProjector;
    private final Struct.StructMember geometryMember;
    private final int crs84;
    private final SRIDSet sridSet;
    private final CreateHandle handle;
    private final OutputStreamWriter writer;
    private final Formatter formatter;
    private final GeoJsonWriter geoJsonWriter;
    private boolean first = true;
    private URI storedAt = null;

    public static ResultOrProblems<GeoJSONWriter> of(Struct type, CreateHandle handle, Project project) {
        return ProblemException.catching(() -> {
            FlattenProjection flattener = new FlattenProjection(".");
            Projector flattenProjector = (Projector)flattener.getProjectionFunction(type).getOrThrow();
            Struct.StructMember geomMember = TupleUtils.findGeometryMember((Struct)flattenProjector.getProjectedType(), (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
            if (geomMember == null) {
                throw new ProblemException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{type}));
            }
            int crs84 = project.getSridSet().get((CoordinateReferenceSystem)project.newBindingContext().bind((Object)"CRS:84", CoordinateReferenceSystem.class).getOrThrow());
            return new GeoJSONWriter(flattenProjector, geomMember, crs84, project.getSridSet(), handle);
        });
    }

    private GeoJSONWriter(Projector flattenProjector, Struct.StructMember geometryMember, int crs84, SRIDSet sridSet, CreateHandle handle) {
        this.flattenProjector = flattenProjector;
        this.geometryMember = geometryMember;
        this.crs84 = crs84;
        this.sridSet = sridSet;
        this.handle = handle;
        this.writer = new OutputStreamWriter(handle.getOutputStream());
        this.formatter = new Formatter(this.writer);
        this.geoJsonWriter = new GeoJsonWriter();
        this.geoJsonWriter.setEncodeCRS(false);
        this.formatter.format("{\n  \"type\":\"FeatureCollection\",\n  \"features\":[\n", new Object[0]);
    }

    public void write(Tuple value) {
        Tuple flattened = (Tuple)this.flattenProjector.apply((Object)value);
        StringBuilder sb = new StringBuilder();
        JSONWriter jsonWriter = new JSONWriter((Appendable)sb);
        jsonWriter.object();
        jsonWriter.key("type");
        jsonWriter.value((Object)"Feature");
        Geometry geom = (Geometry)flattened.fetch(this.geometryMember);
        if (geom != null) {
            jsonWriter.key("geometry");
            jsonWriter.value((Object)new JSONObject(this.geoJsonWriter.write(this.sridSet.reproject(geom, this.crs84))));
        }
        jsonWriter.key("properties");
        try {
            this.writeInternal(flattened, jsonWriter);
        }
        catch (JSONException ex) {
            throw new RiskscapeException((Problems)OutputProblems.get().errorWriting(TupleUtils.getContentSummary((Tuple)flattened), "GeoJSON").withChildren(new Problems[]{Problems.caught((Throwable)ex)}));
        }
        jsonWriter.endObject();
        this.formatter.format("%s%n    %s", this.first ? "" : ",", sb.toString());
        this.first = false;
    }

    protected void writeInternal(Tuple value, JSONWriter jsonWriter) {
        jsonWriter.object();
        for (Struct.StructMember entry : value.getStruct().getMembers()) {
            if (entry.equals((Object)this.geometryMember)) continue;
            String key = entry.getKey();
            if ("geometry".equals(key)) {
                if (entry == this.geometryMember) continue;
                int i = 1;
                while (true) {
                    key = String.format("geometry-%d", i);
                    if (!value.getStruct().hasMember(key)) break;
                    ++i;
                }
            }
            jsonWriter.key(key);
            Object childValue = value.fetch(entry);
            if (childValue instanceof Tuple) {
                this.writeInternal((Tuple)childValue, jsonWriter);
                continue;
            }
            jsonWriter.value(childValue);
        }
        jsonWriter.endObject();
    }

    public void close() throws IOException {
        this.formatter.format("  ]\n}\n", new Object[0]);
        this.writer.close();
        this.storedAt = this.handle.store();
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }
}

