/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import nz.org.riskscape.engine.output.BaseFormat;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.WriterConstructor;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;

public abstract class BaseShapefileFormat
extends BaseFormat {
    public BaseShapefileFormat(String id, String extension, String mediaType) {
        super(id, extension, mediaType, Format.Characteristics.MULTIPLE_FILES, new Format.Characteristics[0]);
    }

    public Optional<WriterConstructor> getWriterConstructor() {
        return Optional.of((context, type, handle, unusedOptions) -> {
            URI outputURI = handle.store();
            File saveTo = new File(outputURI);
            if (!BaseShapefileFormat.containsGeometry((Struct)type)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{type})});
            }
            try {
                return ResultOrProblems.of((Object)this.getWriter(type, saveTo, context));
            }
            catch (IOException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
            }
        });
    }

    protected abstract RiskscapeWriter getWriter(Struct var1, File var2, ExecutionContext var3) throws IOException;
}

