/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public class AxisSwapper {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final CoordinateReferenceSystem newCrs;
    public static final CoordinateFilter AXIS_SWAPPING_FILTER = coordinate -> {
        double oldX = coordinate.x;
        coordinate.x = coordinate.y;
        coordinate.y = oldX;
    };

    public static Optional<AxisSwapper> getForceXY(CoordinateReferenceSystem crs, URI storedAt, ProblemSink problemSink) {
        if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
            CoordinateReferenceSystem newCrs;
            Integer epsgCode = AxisSwapper.lookupEpsgCode(crs);
            if (epsgCode == null) {
                problemSink.log(Problems.foundWith((Object)storedAt, (Problems)PROBLEMS.axisOrderIncorrectInPrj()));
                newCrs = crs;
            } else {
                newCrs = SRIDSet.epsgToCrsWithForceXY((String)("EPSG:" + epsgCode));
            }
            return Optional.of(new AxisSwapper(newCrs));
        }
        return Optional.empty();
    }

    public static Optional<AxisSwapper> getForceEpsgDefined(CoordinateReferenceSystem crs) {
        Integer epsgCode = AxisSwapper.lookupEpsgCode(crs);
        if (epsgCode != null) {
            CoordinateReferenceSystem crsDefined = SRIDSet.epsgToCrs((String)("EPSG:" + epsgCode));
            if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) != CRS.getAxisOrder((CoordinateReferenceSystem)crsDefined)) {
                return Optional.of(new AxisSwapper(crsDefined));
            }
        }
        return Optional.empty();
    }

    private static Integer lookupEpsgCode(CoordinateReferenceSystem crs) {
        try {
            return CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        }
        catch (FactoryException factoryException) {
            return null;
        }
    }

    public Geometry swapAxis(Geometry geom) {
        Geometry clone = geom.copy();
        clone.apply(AXIS_SWAPPING_FILTER);
        clone.geometryChanged();
        return clone;
    }

    @Generated
    public AxisSwapper(CoordinateReferenceSystem newCrs) {
        this.newCrs = newCrs;
    }

    @Generated
    public CoordinateReferenceSystem getNewCrs() {
        return this.newCrs;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem axisOrderIncorrectInPrj();
    }
}

