/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.StructFlattener;
import nz.org.riskscape.engine.output.WriteException;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.MultiGeom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DefaultTransaction;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractDataStoreWriter
extends RiskscapeWriter
implements Closeable {
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String GEOMETRY_ATTRIBUTE = "the_geom";
    private final DataStore dataStore;
    private Struct riskscapeType;
    private final URI storedAt;
    private DefaultTransaction transaction;
    private FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter;
    protected List<StructFlattener.StructMapping> mappings;
    private StructFlattener.StructMapping geometryMapping;
    private SRIDSet sridSet;
    protected boolean setup = false;
    protected int targetSrid;
    protected AxisSwapper axisSwapper;

    public AbstractDataStoreWriter(File outfile, SRIDSet sridSet, DataStore dataStore) throws IOException {
        this.storedAt = outfile.toURI();
        this.sridSet = sridSet;
        this.dataStore = dataStore;
        this.transaction = new DefaultTransaction("riskscape-writer-" + outfile.getAbsolutePath());
    }

    private SimpleFeatureTypeBuilder setupBuilder(String name, CoordinateReferenceSystem crs, Class<?> geometryType) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("riskscape");
        if (crs != null) {
            builder.setCRS(this.outputCrs(crs));
        }
        builder.add(GEOMETRY_ATTRIBUTE, geometryType);
        return builder;
    }

    protected CoordinateReferenceSystem outputCrs(@NonNull CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        this.targetSrid = this.sridSet.get(crs);
        return crs;
    }

    @Override
    public void close() throws IOException {
        if (this.featureWriter != null) {
            this.featureWriter.close();
        }
        this.transaction.commit();
        this.transaction.close();
    }

    public void write(Tuple value) throws WriteException {
        SimpleFeature toWrite;
        try {
            this.setupCrsAndGeoType(value);
        }
        catch (IOException e) {
            throw new WriteException("Failed to setup crs and geometry", e);
        }
        if (!value.getStruct().equals((Object)this.riskscapeType)) {
            throw new IllegalArgumentException(String.format("given value with type does not match required type: %s !=  %s", value.getStruct(), this.riskscapeType));
        }
        try {
            toWrite = (SimpleFeature)this.featureWriter.next();
        }
        catch (IOException e) {
            throw new WriteException("failed to add new feature to data store", e);
        }
        for (StructFlattener.StructMapping member : this.mappings) {
            Object subValue = member.getAccessExpression().evaluate((Object)value);
            if (member == this.geometryMapping) {
                Geometry geom = (Geometry)subValue;
                if (geom != null && this.axisSwapper != null) {
                    geom = this.axisSwapper.swapAxis(geom);
                }
                toWrite.setAttribute(GEOMETRY_ATTRIBUTE, (Object)geom);
                continue;
            }
            this.setAttr(toWrite, member.getKey(), subValue, member.getType());
        }
        try {
            this.featureWriter.write();
        }
        catch (IOException e) {
            throw new WriteException("Failed to write new feature to data store", e);
        }
    }

    protected void setupCrsAndGeoType(Tuple value) throws IOException {
        Class<?> geomClass;
        if (this.setup) {
            return;
        }
        this.riskscapeType = value.getStruct();
        StructFlattener flattener = new StructFlattener();
        this.mappings = flattener.flatten(this.riskscapeType);
        if (this.getAttrNameMaxLength() > 0) {
            flattener.shortenIfNecessary(this.mappings, this.getAttrNameMaxLength());
        }
        this.geometryMapping = this.mappings.stream().filter(m -> m.getType().findAllowNull(Geom.class).isPresent()).findFirst().orElseThrow(() -> new RiskscapeException("output type does not include geometry - output file requires geometry"));
        Geometry geom = (Geometry)this.geometryMapping.getAccessExpression().evaluate((Object)value);
        CoordinateReferenceSystem crs = this.geometryMapping.getType().findAllowNull(Referenced.class).map(Referenced::getCrs).orElse(null);
        if (geom == null) {
            geomClass = this.geomClassTypeFrom(Nullable.strip((Type)this.geometryMapping.getType()));
        } else if (crs == null && geom.getSRID() > 0) {
            crs = this.sridSet.get(geom.getSRID());
            geomClass = geom.getClass();
        } else {
            geomClass = geom.getClass();
        }
        SimpleFeatureTypeBuilder builder = this.setupBuilder("anon", crs, geomClass);
        this.dataStore.createSchema((FeatureType)this.featureTypeFromMappings(builder));
        this.featureWriter = this.dataStore.getFeatureWriter(this.dataStore.getTypeNames()[0], (Transaction)this.transaction);
        this.setup = true;
    }

    private Class geomClassTypeFrom(Type type) {
        Optional<Class> multiGeom = type.find(MultiGeom.class).map(MultiGeom::internalType);
        if (multiGeom.isPresent()) {
            return multiGeom.get();
        }
        Optional<Class> geometryType = type.find(GeomType.class).map(Type::internalType);
        if (geometryType.isPresent()) {
            return geometryType.get();
        }
        return Geometry.class;
    }

    protected int getAttrNameMaxLength() {
        return -1;
    }

    protected void setAttr(SimpleFeature toWrite, String key, Object value, Type type) {
        Object valueToWrite = value instanceof BigDecimal ? value.toString() : value;
        toWrite.setAttribute(key, this.mapValueIfNecessary(valueToWrite, type));
    }

    protected Object mapValueIfNecessary(Object value, Type type) {
        return value;
    }

    protected SimpleFeatureType featureTypeFromMappings(SimpleFeatureTypeBuilder builder) {
        this.mappings.forEach(member -> {
            if (!member.equals(this.geometryMapping)) {
                builder.add(member.getKey(), this.mapJavaType(member.getType().internalType()));
            }
        });
        return builder.buildFeatureType();
    }

    protected Class<?> mapJavaType(Class<?> toMap) {
        if (toMap.equals(BigDecimal.class)) {
            return String.class;
        }
        if (Geometry.class.isAssignableFrom(toMap)) {
            return String.class;
        }
        return toMap;
    }

    @Generated
    public Struct getRiskscapeType() {
        return this.riskscapeType;
    }

    @Generated
    public URI getStoredAt() {
        return this.storedAt;
    }
}

