/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.join.RealizedExpressionJoinIndexer;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexer
extends RealizedExpressionJoinIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpatialIndexer.class);
    public static final JoinIndexer.Constructor CONSTRUCTOR = (join, expressionRealizer, initalIndexSize) -> new SpatialIndexer(join, expressionRealizer);
    public static final List<String> ALLOWED_GEO_FUNCTIONS = ImmutableList.of((Object)"contains", (Object)"intersects", (Object)"within");
    private STRtree strTree = new STRtree(16);
    private boolean strTreeBuilt = false;

    public SpatialIndexer(Join join, TupleIterator rhs, ExpressionRealizer expressionRealizer) {
        this(join, expressionRealizer);
        while (rhs.hasNext()) {
            this.addToIndex((Tuple)rhs.next());
        }
    }

    public SpatialIndexer(Join join, ExpressionRealizer expressionRealizer) {
        super(join, expressionRealizer);
        this.processIndexableMetadata();
    }

    @Override
    public boolean isUsable() {
        return this.rhsExpression != null && this.lhsExpression != null && Nullable.strip((Type)this.lhsExpression.getResultType()) == Types.GEOMETRY && Nullable.strip((Type)this.rhsExpression.getResultType()) == Types.GEOMETRY;
    }

    @Override
    protected boolean isAllowed(RealizedExpression childFilter) {
        if (super.isAllowed(childFilter) && childFilter.getExpression() instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)childFilter.getExpression();
            return ALLOWED_GEO_FUNCTIONS.contains(functionCall.getIdentifier().getValue());
        }
        return false;
    }

    @Override
    public TupleIterator createRhsIterator(Tuple lhs) {
        this.checkIfIndexBuilt();
        Geometry lhsGeometry = (Geometry)this.lhsExpression.evaluate((Object)lhs);
        Envelope lhsEnvelope = lhsGeometry.getEnvelopeInternal();
        List items = this.strTree.query(lhsEnvelope);
        if (items.isEmpty()) {
            return TupleIterator.EMPTY;
        }
        if (items.size() == 1) {
            return TupleIterator.singleton((Tuple)((Tuple)items.get(0)));
        }
        return TupleIterator.wrapped(items.iterator(), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfIndexBuilt() {
        if (!this.strTreeBuilt) {
            STRtree sTRtree = this.strTree;
            synchronized (sTRtree) {
                if (!this.strTreeBuilt) {
                    this.strTree.build();
                    this.strTreeBuilt = true;
                }
            }
        }
    }

    @Override
    public void addToIndex(Tuple toCache) {
        Geometry rhsGeom = (Geometry)this.rhsExpression.evaluate((Object)toCache);
        if (rhsGeom == null) {
            return;
        }
        Envelope envelopeInternal = rhsGeom.getEnvelopeInternal();
        this.strTree.insert(envelopeInternal, (Object)toCache);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

