/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.join.ExpressionJoinCondition;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.PropertyAccess;

public abstract class RealizedExpressionJoinIndexer
extends JoinIndexer {
    protected RealizedExpression lhsExpression;
    protected RealizedExpression rhsExpression;
    protected RealizedExpression operator;

    public RealizedExpressionJoinIndexer(Join join, ExpressionRealizer expressionRealizer) {
        super(join, expressionRealizer);
        this.processIndexableMetadata();
    }

    protected boolean isAllowed(RealizedExpression expression) {
        return Nullable.strip((Type)expression.getResultType()).equals(Types.BOOLEAN);
    }

    @Override
    public boolean isUsable() {
        return this.rhsExpression != null && this.lhsExpression != null;
    }

    protected final void processIndexableMetadata() {
        if (!(this.join.getOn() instanceof ExpressionJoinCondition)) {
            return;
        }
        ExpressionJoinCondition filtered = (ExpressionJoinCondition)this.join.getOn();
        this.processFilter(filtered.getExpression());
    }

    private void processFilter(RealizedExpression filter) {
        if (filter.getExpression() instanceof BinaryOperation) {
            BinaryOperation operation = (BinaryOperation)filter.getExpression();
            if (operation.getNormalizedOperator() == TokenTypes.OR) {
                return;
            }
            if (operation.getNormalizedOperator() == TokenTypes.AND) {
                for (RealizedExpression childFilter : filter.getDependencies()) {
                    if (!this.isAllowed(childFilter)) continue;
                    this.processFilter(childFilter);
                    if (!this.isUsable()) continue;
                    return;
                }
                return;
            }
        }
        if (!this.isAllowed(filter)) {
            return;
        }
        this.operator = filter;
        RealizedExpression effectiveConstantExpression = this.findEffectiveConstantExpression(this.operator);
        RealizedExpression indexableExpression = this.findIndexableExpression(this.operator);
        if (effectiveConstantExpression == null || indexableExpression == null) {
            return;
        }
        this.lhsExpression = (RealizedExpression)this.expressionRealizer.realize((Type)this.join.getLhs(), effectiveConstantExpression.getExpression()).orElse(null);
        this.rhsExpression = (RealizedExpression)this.expressionRealizer.realize((Type)this.join.getRhs(), indexableExpression.getExpression()).orElse(null);
    }

    private RealizedExpression findEffectiveConstantExpression(RealizedExpression comparisonOperator) {
        for (RealizedExpression dep : comparisonOperator.getDependencies()) {
            if (!RealizedExpressionTest.matches(dep, firstPath -> this.join.getLhs().hasMember(firstPath))) continue;
            return dep;
        }
        return null;
    }

    private RealizedExpression findIndexableExpression(RealizedExpression comparisonOperator) {
        for (RealizedExpression dep : comparisonOperator.getDependencies()) {
            if (!RealizedExpressionTest.matches(dep, firstPath -> this.join.getRhs().hasMember(firstPath))) continue;
            return dep;
        }
        return null;
    }

    private static class RealizedExpressionTest {
        private final Predicate<String> firstNodeTest;
        private boolean foundMatchedPropertyAccess;
        private boolean foundUnmatchedPropertyAccess;

        static boolean matches(RealizedExpression toTest, Predicate<String> firstNodeTest) {
            RealizedExpressionTest tester = new RealizedExpressionTest(firstNodeTest);
            tester.testPropertyExpression(toTest);
            return tester.matches();
        }

        boolean matches() {
            return this.foundMatchedPropertyAccess && !this.foundUnmatchedPropertyAccess;
        }

        private void testPropertyExpression(RealizedExpression input) {
            PropertyAccess pa;
            if (input.getExpression() instanceof PropertyAccess && !(pa = (PropertyAccess)input.getExpression()).getReceiver().isPresent()) {
                if (this.firstNodeTest.test(((Token)pa.getIdentifiers().get(0)).getValue())) {
                    this.foundMatchedPropertyAccess = true;
                } else {
                    this.foundUnmatchedPropertyAccess = true;
                }
            }
            for (RealizedExpression dep : input.getDependencies()) {
                this.testPropertyExpression(dep);
            }
        }

        @Generated
        public RealizedExpressionTest(Predicate<String> firstNodeTest) {
            this.firstNodeTest = firstNodeTest;
        }
    }
}

