/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.ExpressionRealizer;

public class NoIndexIndexer
extends JoinIndexer {
    public static final int DEFAULT_INITIAL_INDEX_SIZE = 100000;
    public static final JoinIndexer.Constructor CONSTRUCTOR = (join, expressionRealizer, initialIndexSize) -> new NoIndexIndexer(join, initialIndexSize.orElse(100000), expressionRealizer);
    private final ArrayList<Tuple> cachedValues;

    public NoIndexIndexer(Join join, int initialIndexSize, ExpressionRealizer expressionRealizer) {
        super(join, expressionRealizer);
        this.cachedValues = Lists.newArrayListWithCapacity((int)initialIndexSize);
    }

    @Override
    public void addToIndex(Tuple rhs) {
        this.cachedValues.add(rhs);
    }

    @Override
    public TupleIterator createRhsIterator(Tuple lhs) {
        return TupleIterator.wrapped(this.cachedValues.iterator(), Optional.empty());
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

