/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinCondition;
import nz.org.riskscape.engine.join.JoinType;
import nz.org.riskscape.engine.join.ProblemCodes;
import nz.org.riskscape.engine.types.DuplicateKeysException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ResultOrProblems;

public class Joiner
implements Join {
    private final Struct lhs;
    private final Struct rhs;
    @NonNull
    private final JoinCondition on;
    @NonNull
    private final JoinType joinType;
    @NonNull
    private final Struct joinedType;

    public static ResultOrProblems<Joiner> build(Struct lhs, Struct rhs, JoinCondition on, JoinType joinType) {
        Struct joinedType;
        try {
            joinedType = Joiner.buildJoined(joinType, lhs, rhs);
        }
        catch (DuplicateKeysException ex) {
            List dups = ex.getDuplicates().stream().map(d -> d.getKey()).collect(Collectors.toList());
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.DUPLICATE_KEYS, (Object[])new Object[]{dups})});
        }
        Joiner join = new Joiner(lhs, rhs, joinedType, on, joinType);
        List validationErrors = on.validate(joinedType);
        if (Problem.hasErrors((Collection)validationErrors)) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.JOIN_CONDITION_INVALID, (Object[])new Object[]{on, joinedType}).withChildren(validationErrors)});
        }
        return ResultOrProblems.of((Object)join);
    }

    private Joiner(Struct lhs, Struct rhs, JoinCondition on, JoinType joinType) throws DuplicateKeysException {
        this.lhs = lhs;
        this.rhs = rhs;
        this.on = on;
        this.joinType = joinType;
        this.joinedType = Joiner.buildJoined(joinType, lhs, rhs);
    }

    private Joiner(Struct lhs, Struct rhs, Struct joinedType, JoinCondition on, JoinType joinType) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.on = on;
        this.joinType = joinType;
        this.joinedType = joinedType;
    }

    public Joiner(Struct lhs, Struct rhs, JoinCondition on) {
        this(lhs, rhs, on, JoinType.INNER);
    }

    private static Struct buildJoined(JoinType joinType, Struct lhs, Struct rhs) {
        Struct.StructBuilder builder = new Struct.StructBuilder();
        builder.addAll(lhs);
        for (Struct.StructMember member : rhs.getMembers()) {
            builder.add(member.getKey(), Joiner.nullable(joinType, member.getType()));
        }
        return builder.build();
    }

    private static Type nullable(JoinType joinType, Type type) {
        if (joinType.isNullable()) {
            return Nullable.of((Type)type);
        }
        return type;
    }

    public Joiner withJoinType(JoinType newJoinType) {
        return new Joiner(this.lhs, this.rhs, this.on, newJoinType);
    }

    public Joiner withJoinConditon(JoinCondition newOn) {
        return new Joiner(this.lhs, this.rhs, this.joinedType, newOn, this.joinType);
    }

    public Tuple join(Tuple lhsTuple, Tuple rhsTuple) {
        Tuple joined = new Tuple(this.joinedType);
        joined.setAll(lhsTuple);
        if (rhsTuple != null) {
            joined.setAll(this.lhs.size(), rhsTuple);
        } else if (this.joinType != JoinType.LEFT_OUTER) {
            throw new NullPointerException("rhs null and not a left outer join");
        }
        return joined;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Joiner)) {
            return false;
        }
        Joiner other = (Joiner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Struct this$lhs = this.getLhs();
        Struct other$lhs = other.getLhs();
        if (this$lhs == null ? other$lhs != null : !this$lhs.equals(other$lhs)) {
            return false;
        }
        Struct this$rhs = this.getRhs();
        Struct other$rhs = other.getRhs();
        if (this$rhs == null ? other$rhs != null : !this$rhs.equals(other$rhs)) {
            return false;
        }
        JoinCondition this$on = this.getOn();
        JoinCondition other$on = other.getOn();
        if (this$on == null ? other$on != null : !this$on.equals(other$on)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !this$joinType.equals(other$joinType)) {
            return false;
        }
        Struct this$joinedType = this.getJoinedType();
        Struct other$joinedType = other.getJoinedType();
        return !(this$joinedType == null ? other$joinedType != null : !this$joinedType.equals(other$joinedType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Joiner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Struct $lhs = this.getLhs();
        result = result * 59 + ($lhs == null ? 43 : $lhs.hashCode());
        Struct $rhs = this.getRhs();
        result = result * 59 + ($rhs == null ? 43 : $rhs.hashCode());
        JoinCondition $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : $on.hashCode());
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : $joinType.hashCode());
        Struct $joinedType = this.getJoinedType();
        result = result * 59 + ($joinedType == null ? 43 : $joinedType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Joiner(lhs=" + String.valueOf(this.getLhs()) + ", rhs=" + String.valueOf(this.getRhs()) + ", on=" + String.valueOf(this.getOn()) + ", joinType=" + String.valueOf(this.getJoinType()) + ", joinedType=" + String.valueOf(this.getJoinedType()) + ")";
    }

    @Generated
    public Struct getLhs() {
        return this.lhs;
    }

    @Generated
    public Struct getRhs() {
        return this.rhs;
    }

    @NonNull
    @Generated
    public JoinCondition getOn() {
        return this.on;
    }

    @NonNull
    @Generated
    public JoinType getJoinType() {
        return this.joinType;
    }

    @NonNull
    @Generated
    public Struct getJoinedType() {
        return this.joinedType;
    }
}

