/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.join.RealizedExpressionJoinIndexer;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpressionConverter;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.PropertyAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashIndexer
extends RealizedExpressionJoinIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HashIndexer.class);
    public static final int DEFAULT_INITIAL_INDEX_SIZE = 100000;
    public static final JoinIndexer.Constructor CONSTRUCTOR = (join, expressionRealizer, initialIndexSize) -> new HashIndexer(join, expressionRealizer, initialIndexSize.orElse(100000));
    private BaseExpressionConverter converter = new BaseExpressionConverter(){

        public Expression visit(FunctionCall expression, Object data) {
            ArrayList convertedArgs = Lists.newArrayListWithCapacity((int)expression.getArguments().size());
            for (FunctionCall.Argument arg : expression.getArguments()) {
                String asRL = arg.getExpression().toSource();
                if (asRL.equals(HashIndexer.this.lhsExpression.getExpression().toSource())) {
                    convertedArgs.add(new FunctionCall.Argument((Expression)PropertyAccess.of((String[])new String[]{"lhs"})));
                    continue;
                }
                if (asRL.equals(HashIndexer.this.rhsExpression.getExpression().toSource())) {
                    convertedArgs.add(new FunctionCall.Argument((Expression)PropertyAccess.of((String[])new String[]{"rhs"})));
                    continue;
                }
                convertedArgs.add(arg);
            }
            return new FunctionCall(expression.getIdentifier(), (List)convertedArgs);
        }

        public Expression visit(BinaryOperation expression, Object data) {
            boolean leftIsLeft = HashIndexer.this.lhsExpression.getExpression().toSource().equals(expression.getLhs().toSource());
            return new BinaryOperation((Expression)(leftIsLeft ? PropertyAccess.of((String[])new String[]{"lhs"}) : PropertyAccess.of((String[])new String[]{"rhs"})), expression.getOperator(), (Expression)(leftIsLeft ? PropertyAccess.of((String[])new String[]{"rhs"}) : PropertyAccess.of((String[])new String[]{"lhs"})));
        }
    };
    private final Map<Object, List<Tuple>> index;
    private boolean equalityJoin = false;
    private Struct joinTestType = null;
    private RealizedExpression joinTest;

    public HashIndexer(Join join, ExpressionRealizer expressionRealizer, int initialIndexSize) {
        super(join, expressionRealizer);
        this.index = Maps.newHashMapWithExpectedSize((int)initialIndexSize);
        this.init();
    }

    private void init() {
        if (!super.isUsable()) {
            return;
        }
        if (this.operator != null && this.operator.getExpression() instanceof BinaryOperation && ((BinaryOperation)this.operator.getExpression()).getOperator().type == TokenTypes.EQUALS) {
            this.equalityJoin = true;
        }
        this.joinTestType = Struct.of((String)"lhs", (Type)this.lhsExpression.getResultType(), (String)"rhs", (Type)this.rhsExpression.getResultType());
        ResultOrProblems convertedAndRealized = this.expressionRealizer.realize((Type)this.joinTestType, (Expression)this.operator.getExpression().accept((ExpressionVisitor)this.converter, (Object)this.lhsExpression.getExpression().toSource()));
        if (!convertedAndRealized.hasErrors()) {
            this.joinTest = (RealizedExpression)convertedAndRealized.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToIndex(Tuple toCache) {
        Object rhsValue = this.rhsExpression.evaluate((Object)toCache);
        HashIndexer hashIndexer = this;
        synchronized (hashIndexer) {
            this.index.computeIfAbsent(rhsValue, k -> Lists.newArrayList()).add(toCache);
        }
    }

    @Override
    public TupleIterator createRhsIterator(Tuple lhs) {
        Object lhsValue = this.lhsExpression.evaluate((Object)lhs);
        if (this.equalityJoin) {
            List rhsValues = this.index.getOrDefault(lhsValue, Collections.emptyList());
            return TupleIterator.wrapped(rhsValues.iterator(), Optional.empty());
        }
        ArrayList combined = Lists.newArrayList();
        for (Map.Entry<Object, List<Tuple>> entry : this.index.entrySet()) {
            Tuple toTest = Tuple.ofValues((Struct)this.joinTestType, (Object[])new Object[]{lhsValue, entry.getKey()});
            if (!Boolean.TRUE.equals(this.joinTest.evaluate((Object)toTest))) continue;
            combined.addAll((Collection)entry.getValue());
        }
        return TupleIterator.wrapped(combined.iterator(), Optional.empty());
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.joinTest != null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

