/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.JoinCondition;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public class ExpressionJoinCondition
implements JoinCondition {
    private final RealizedExpression expression;
    private final List<Problem> problems;

    public static ResultOrProblems<ExpressionJoinCondition> realize(Expression expression, Struct inputType, ExpressionRealizer eRealizer) {
        return eRealizer.realize((Type)inputType, expression).flatMap((re, p) -> {
            if (Nullable.strip((Type)re.getResultType()) != Types.BOOLEAN) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Expression '%s' must return Boolean. Found: %s", (Object[])new Object[]{expression.toSource(), re.getResultType()})});
            }
            return ResultOrProblems.of((Object)new ExpressionJoinCondition((RealizedExpression)re, (List<Problem>)p), (List)p);
        });
    }

    public boolean matches(Tuple row) {
        return this.expression.evaluate((Object)row) == Boolean.TRUE;
    }

    public List<Problem> validate(Struct joinedType) {
        if (joinedType != this.expression.getInputType()) {
            return Arrays.asList(Problem.error((String)"Joined type not the same instance as realized with", (Object[])new Object[0]));
        }
        return this.problems;
    }

    @Generated
    private ExpressionJoinCondition(RealizedExpression expression, List<Problem> problems) {
        this.expression = expression;
        this.problems = problems;
    }

    @Generated
    public RealizedExpression getExpression() {
        return this.expression;
    }
}

