/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.Join;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.join.LopsidedJoinIterator;
import nz.org.riskscape.engine.join.LopsidedJoiner;
import nz.org.riskscape.engine.join.NoIndexIndexer;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.types.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJoiner
implements LopsidedJoiner<JoinIndexer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJoiner.class);
    private final Join join;
    private final List<JoinIndexer.Constructor> indexConstructors;
    private final ExpressionRealizer expressionRealizer;
    private final Optional<Integer> initalIndexSize;

    public Struct getLhs() {
        return this.join.getLhs();
    }

    public Struct getRhs() {
        return this.join.getRhs();
    }

    public Struct getProducedType() {
        return this.join.getJoinedType();
    }

    public JoinIndexer createRhsIndex() {
        JoinIndexer indexer = NoIndexIndexer.CONSTRUCTOR.construct(this.join, this.expressionRealizer, this.initalIndexSize);
        for (JoinIndexer.Constructor indexConstructor : this.indexConstructors) {
            JoinIndexer possible = indexConstructor.construct(this.join, this.expressionRealizer, this.initalIndexSize);
            if (!possible.isUsable()) continue;
            indexer = possible;
            break;
        }
        return indexer;
    }

    public void addToRhsIndex(Tuple rhs, JoinIndexer index) {
        index.addToIndex(rhs);
    }

    public TupleIterator join(JoinIndexer index, Tuple lhs) {
        return new LopsidedJoinIterator(this.join, lhs, index.createRhsIterator(lhs));
    }

    @Generated
    public DefaultJoiner(Join join, List<JoinIndexer.Constructor> indexConstructors, ExpressionRealizer expressionRealizer, Optional<Integer> initalIndexSize) {
        this.join = join;
        this.indexConstructors = indexConstructors;
        this.expressionRealizer = expressionRealizer;
        this.initalIndexSize = initalIndexSize;
    }
}

