/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.jai;

import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.jai.InstrumentedTileCache;
import nz.org.riskscape.engine.spi.EngineBootstrapper;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileCacheBootstrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TileCacheBootstrapper.class);
    public static final String TILE_CACHE_SETTING = "global.tile-cache-percent";
    public static final double DEFAULT_TILE_CACHE_PERCENT = 5.0;
    public static final EngineBootstrapper INSTANCE = new EngineBootstrapper("tile-cache-initialization", TileCacheBootstrapper::initializeTileCache);

    private static void initializeTileCache(Engine.Writeable engine) {
        InstrumentedTileCache tileCache = new InstrumentedTileCache(JAI.getDefaultInstance().getTileCache(), engine.getDiagnostics().getMetricRegistry());
        long currCacheSize = tileCache.getMemoryCapacity();
        List tileCacheSetting = engine.getSetting(TILE_CACHE_SETTING);
        double percent = tileCacheSetting.size() > 0 ? Double.parseDouble((String)tileCacheSetting.get(0)) : 5.0;
        long newCacheSize = (long)(percent / 100.0 * (double)Runtime.getRuntime().maxMemory());
        if (newCacheSize > currCacheSize) {
            log.info("TileCache capacity set to {} MiB", (Object)Precision.round((double)((double)newCacheSize / 1024.0 / 1024.0), (int)1));
            tileCache.setMemoryCapacity(newCacheSize);
        } else {
            log.info("TileCache capacity not changed, percentage was below JAI default");
        }
        JAI.getDefaultInstance().setTileCache((TileCache)tileCache);
    }
}

