/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.jai;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Comparator;
import javax.media.jai.TileCache;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedTileCache
implements TileCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentedTileCache.class);
    private final TileCache delegate;
    private final Meter hitMeter;
    private final Meter missMeter;

    public InstrumentedTileCache(TileCache tileCache, MetricRegistry metricRegistry) {
        this.delegate = tileCache;
        this.hitMeter = metricRegistry.meter("tile-cache.hits");
        this.missMeter = metricRegistry.meter("tile-cache.misses");
    }

    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        Raster tile = this.delegate.getTile(owner, tileX, tileY);
        if (tile != null) {
            this.hitMeter.mark();
            if (log.isDebugEnabled()) {
                log.debug("Tile HIT: (" + tileX + "," + tileY + ")");
            }
        } else {
            this.missMeter.mark();
            if (log.isDebugEnabled()) {
                log.debug("Tile MISS: (" + tileX + "," + tileY + ")");
            }
        }
        return tile;
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster data) {
        this.delegate.add(owner, tileX, tileY, data);
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster data, Object tileCacheMetric) {
        this.delegate.add(owner, tileX, tileY, data, tileCacheMetric);
    }

    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        this.delegate.addTiles(owner, tileIndices, tiles, tileCacheMetric);
    }

    public void remove(RenderedImage owner, int tileX, int tileY) {
        this.delegate.remove(owner, tileX, tileY);
    }

    public void removeTiles(RenderedImage owner) {
        this.delegate.removeTiles(owner);
    }

    public void flush() {
        this.delegate.flush();
    }

    public long getMemoryCapacity() {
        return this.delegate.getMemoryCapacity();
    }

    public void setMemoryCapacity(long memoryCapacity) {
        this.delegate.setMemoryCapacity(memoryCapacity);
    }

    public int getTileCapacity() {
        return this.delegate.getTileCapacity();
    }

    public void setTileCapacity(int tileCapacity) {
        this.delegate.setTileCapacity(tileCapacity);
    }

    public float getMemoryThreshold() {
        return this.delegate.getMemoryThreshold();
    }

    public void setMemoryThreshold(float threshold) {
        this.delegate.setMemoryThreshold(threshold);
    }

    public Comparator getTileComparator() {
        return this.delegate.getTileComparator();
    }

    public void setTileComparator(Comparator comparator) {
        this.delegate.setTileComparator(comparator);
    }

    public Raster[] getTiles(RenderedImage owner) {
        return this.delegate.getTiles(owner);
    }

    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        return this.delegate.getTiles(owner, tileIndices);
    }

    public void memoryControl() {
        this.delegate.memoryControl();
    }
}

