/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.io;

import com.codahale.metrics.Counter;
import com.google.common.io.CountingOutputStream;
import it.geosolutions.io.output.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.io.DataOutputStreamTupleWriter;
import nz.org.riskscape.engine.io.OutOfStorageSpaceException;
import nz.org.riskscape.engine.io.TupleWriter;

public class DiskStorageWriter
implements TupleWriter,
Closeable {
    public static final int BUFFER_SIZE = 2000000;
    public static final long OUT_OF_DISK_THRESHOLD_BYTES = 1024L;
    private final File file;
    private final OutputStream buffer;
    private final CountingOutputStream counter;
    private final DataOutputStreamTupleWriter writer;
    private final Counter metricsCounter;

    public DiskStorageWriter(File file, boolean compressed) throws IOException {
        this(file, compressed, null);
    }

    public DiskStorageWriter(File file, boolean compressed, Counter metricsCounter) throws IOException {
        this.file = file;
        this.metricsCounter = metricsCounter;
        FileOutputStream fos = new FileOutputStream(file);
        this.buffer = compressed ? new GZIPOutputStream((OutputStream)fos, 2000000, false) : new FastBufferedOutputStream((OutputStream)fos);
        this.counter = new CountingOutputStream(this.buffer);
        this.writer = new DataOutputStreamTupleWriter(new DataOutputStream((OutputStream)this.counter));
    }

    public void write(Tuple tuple) throws IOException {
        try {
            long start = this.counter.getCount();
            this.writer.write(tuple);
            long delta = this.counter.getCount() - start;
            if (this.metricsCounter != null) {
                this.metricsCounter.inc(delta);
            }
        }
        catch (IOException e) {
            this.maybeRaiseDiskSpaceException(e);
            throw e;
        }
    }

    private void maybeRaiseDiskSpaceException(IOException e) throws IOException {
        FileStore fileStore = Files.getFileStore(this.file.toPath());
        long usableSpace = fileStore.getUsableSpace();
        if (usableSpace < 1024L) {
            throw new OutOfStorageSpaceException(fileStore.toString(), usableSpace, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void remove() throws IOException {
        this.file.delete();
    }

    public long getBytesWritten() throws IOException {
        return this.counter.getCount();
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

