/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.io;

import com.google.common.io.CountingInputStream;
import it.geosolutions.io.input.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.io.DataInputStreamTupleReader;
import nz.org.riskscape.engine.io.TupleReader;
import nz.org.riskscape.engine.types.Struct;

public class DiskStorageReader
implements TupleReader {
    private final File file;
    private final FileInputStream fin;
    private final InputStream buffer;
    private final DataInputStreamTupleReader reader;
    private final CountingInputStream counter;

    public DiskStorageReader(File file, boolean compressed) throws IOException {
        this.file = file;
        this.fin = new FileInputStream(file);
        this.counter = new CountingInputStream((InputStream)this.fin);
        this.buffer = compressed ? new GZIPInputStream((InputStream)this.counter) : new FastBufferedInputStream((InputStream)this.counter);
        this.reader = new DataInputStreamTupleReader(new DataInputStream(this.buffer));
    }

    public Tuple read(Struct expected) throws IOException {
        Tuple read;
        try {
            read = this.reader.read(expected);
        }
        catch (EOFException ex) {
            FileChannel channel = this.fin.getChannel();
            if (channel.size() != channel.position()) {
                throw ex;
            }
            read = null;
        }
        return read;
    }

    public long getBytesRead() {
        return this.counter.getCount();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

