/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.io;

import com.codahale.metrics.Counter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import lombok.Generated;
import nz.org.riskscape.engine.io.DiskStorageReader;
import nz.org.riskscape.engine.io.DiskStorageWriter;
import nz.org.riskscape.engine.io.TupleReader;
import nz.org.riskscape.engine.io.TupleStorage;
import nz.org.riskscape.engine.io.TupleWriter;

public class DiskStorage
implements TupleStorage {
    public static final String TUPLES_FILE_FORMAT = "tuples-%05d";
    public static final Pattern TUPLES_FILE_PATTERN = Pattern.compile("tuples-[0-9]{3}");
    private final Path dataDir;
    private final boolean useCompression;
    private Counter counter;

    public DiskStorage(Path dataDir) {
        this.dataDir = dataDir;
        this.useCompression = false;
    }

    public DiskStorage() {
        this.useCompression = false;
        this.dataDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public DiskStorage(Path dataDir, boolean useCompression, Counter counter) {
        this.dataDir = dataDir;
        this.useCompression = useCompression;
        this.counter = counter;
    }

    public DiskStorage(Counter counter) {
        this();
        this.counter = counter;
    }

    public DiskStorage(Path dataDir, boolean useCompression) {
        this(dataDir, useCompression, null);
    }

    public TupleWriter createTemporaryWriter() throws IOException {
        File ret = File.createTempFile("tuples", "", this.dataDir.toFile());
        ret.deleteOnExit();
        return new DiskStorageWriter(ret, this.useCompression, this.counter);
    }

    public DiskStorageReader getReader(DiskStorageWriter writer) throws IOException {
        if (!writer.getFile().exists()) {
            throw new FileNotFoundException("Attempting to create a reader from a writer with no file - has it been cleaned up?");
        }
        return new DiskStorageReader(writer.getFile(), this.useCompression);
    }

    public TupleReader getReader(TupleWriter writer) throws IOException {
        return this.getReader((DiskStorageWriter)writer);
    }

    @Generated
    public Path getDataDir() {
        return this.dataDir;
    }
}

