/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.ini;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import nz.org.riskscape.engine.RiskscapeIOException;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class IniParser {
    public static Ini parse(URI uri) throws RiskscapeIOException {
        try {
            return IniParser.parse(uri.toURL().openStream());
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could not load INI resource. Cause: " + e.getMessage(), (Exception)e);
        }
    }

    public static Ini parse(InputStream input) throws RiskscapeIOException {
        try {
            Ini ini = new Ini();
            Config config = new Config();
            config.setMultiSection(true);
            config.setEscape(false);
            config.setEscapeNewline(true);
            ini.setConfig(config);
            ini.load(input);
            return ini;
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could not load INI resource. Cause: " + e.getMessage(), (Exception)e);
        }
    }

    public static LinkedHashMap<String, List<?>> toMap(Profile.Section section) {
        Set keySet = section.keySet();
        LinkedHashMap toReturn = new LinkedHashMap(section.size());
        for (String key : keySet) {
            toReturn.put(key, section.getAll((Object)key));
        }
        return toReturn;
    }
}

