/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.ini;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.auth.Secret;
import nz.org.riskscape.engine.auth.SecretBuilder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class IniFileSecretBuilder {
    private final Engine engine;
    private final IdentifiedCollection<SecretBuilder> secretBuilders;
    private final IdentifiedCollection<Secret> engineSecrets;

    public IniFileSecretBuilder(Engine engine) {
        this.engine = engine;
        this.secretBuilders = engine.getCollectionByClass(SecretBuilder.class);
        this.engineSecrets = engine.getCollectionByClass(Secret.class);
    }

    public void addSecret(String id, ConfigSection section) {
        this.engineSecrets.add(id, (Resource)new Resource.PseudoResource(section.getLocation()), () -> {
            ResultOrProblems<Secret> built = this.build(id, section);
            if (built.hasProblems()) {
                this.engine.getProblemSink().accept(built.getAsSingleProblem());
            }
            return built;
        });
    }

    public ResultOrProblems<Secret> build(String id, ConfigSection section) {
        return ProblemException.catching(() -> {
            BoundParameters bound;
            SecretBuilder secretBuilder = (SecretBuilder)this.secretBuilders.getOr((String)section.getOneRequired("framework").getOrThrow()).getOrThrow();
            BindingContext bindingContext = this.engine.newBindingContext();
            HashMap<ConfigString, ArrayList> unbound = new HashMap<ConfigString, ArrayList>(section.toConfigMap());
            URI uri = section.getLocation();
            unbound.putIfAbsent(ConfigString.wrap((URI)uri, (CharSequence)"id"), Lists.newArrayList((Object[])new ConfigString[]{ConfigString.wrap((URI)uri, (CharSequence)id)}));
            Parameter hostnameParameter = secretBuilder.getParameters().get("hostname");
            if (hostnameParameter != null && !hostnameParameter.hasDefaultValue()) {
                unbound.putIfAbsent(ConfigString.wrap((URI)uri, (CharSequence)"hostname"), Lists.newArrayList((Object[])new ConfigString[]{ConfigString.wrap((URI)uri, (CharSequence)id)}));
            }
            if (!(bound = secretBuilder.getParameters().bindConfig(bindingContext, unbound)).isValid()) {
                throw new ProblemException((Problems)Problems.toSingleProblem((List)bound.getValidationProblems()));
            }
            return (Secret)((ResultOrProblems)secretBuilder.getBuilder().apply(bound)).getOrThrow();
        }).composeProblems((sev, probs) -> Problems.foundWith((Object)section.getLocation(), (List)probs));
    }
}

