/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.ini;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterProperties;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.bind.ParameterTemplate;
import nz.org.riskscape.engine.bind.TypedProperty;
import nz.org.riskscape.engine.bind.UserDefinedParameter;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class IniFileParameterBuilder
extends IdentifiedObjectBuilder.Base<UserDefinedParameter> {
    private final Project project;
    private BindingContext context;
    public static final String PARAMETER_KEY = "parameter";
    public static final String TEMPLATE = "template";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String PROPERTIES = "properties";
    private static final String CHOICES = "choices";
    private static final String DEFAULT = "default";
    public static final List<String> KEYS = Arrays.asList("label", "description", "choices", "properties", "template", "default");
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public static List<Pair<String, String>> getSettings(ParameterTemplate template) {
        String choices;
        ArrayList<Pair<String, String>> settings = new ArrayList<Pair<String, String>>();
        template.getLabel().ifPresent(label -> settings.add(Pair.of((Object)LABEL, (Object)label)));
        template.getDescription().ifPresent(desc -> settings.add(Pair.of((Object)DESCRIPTION, (Object)desc)));
        String properties = template.getProperties().stream().map(p -> p.getKeyword() + p.getValueOr().map(val -> ": " + val.toString()).orElse("")).collect(Collectors.joining(", "));
        if (properties.length() > 0) {
            settings.add(Pair.of((Object)PROPERTIES, (Object)properties));
        }
        if ((choices = template.getChoices().stream().map(c -> c.getLabel().map(key -> key + ": ").orElse("") + c.getValue().toString()).collect(Collectors.joining(", "))).length() > 0) {
            settings.add((Pair<String, String>)Pair.of((Object)CHOICES, (Object)choices));
        }
        return settings;
    }

    public IniFileParameterBuilder(Project project) {
        super(UserDefinedParameter.class, PARAMETER_KEY);
        this.project = project;
        this.context = project.newBindingContext();
    }

    public ParameterTemplate build(Map<String, List<String>> config) throws ProblemException {
        ParameterTemplate base = ParameterTemplate.EMPTY;
        if (config.containsKey(TEMPLATE)) {
            String templateId = config.get(TEMPLATE).get(0);
            base = (ParameterTemplate)this.project.getParameterTemplates().getOr(templateId).drainWarnings((Consumer)this.project.getProblemSink()).map(p -> p.getTemplate()).getOrThrow();
        }
        Optional<String> description = base.getDescription();
        Optional<String> label = base.getLabel();
        LinkedHashSet<ParameterProperty> properties = base.getProperties();
        ArrayList<ParameterTemplate.Choice> choices = base.getChoices();
        Optional<String> defaultValue = base.getDefaultValue();
        if (config.containsKey(DESCRIPTION)) {
            description = Optional.of(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)config.get(DESCRIPTION)));
        }
        if (config.containsKey(LABEL)) {
            label = Optional.of(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)config.get(LABEL)));
        }
        if (config.containsKey(PROPERTIES)) {
            properties = new LinkedHashSet<ParameterProperty>();
            for (String configLine : config.get(PROPERTIES)) {
                for (String toParse : configLine.split(",")) {
                    Optional value;
                    String[] parts = toParse.split(":", 2);
                    String keyword = parts[0].trim();
                    ParameterProperty property = (ParameterProperty)ParameterProperties.build(this.context, keyword, value = parts.length > 1 ? Optional.of(parts[1].trim()) : Optional.empty()).getOrThrow();
                    List<Problem> problems = ParameterProperties.checkCompatible(property, properties);
                    if (!problems.isEmpty()) {
                        throw new ProblemException((Problems)Problems.foundWith(ParameterProperties.class, problems));
                    }
                    properties.add(property);
                }
            }
        }
        if (config.containsKey(CHOICES)) {
            choices = new ArrayList<ParameterTemplate.Choice>();
            for (String choice : config.get(CHOICES)) {
                Expression expression = (Expression)ExpressionParser.INSTANCE.parseOr("{" + choice + "}").getOrThrow(PROBLEMS.couldNotParseOption(choice));
                StructDeclaration struct = (StructDeclaration)expression.isA(StructDeclaration.class).orElseThrow(() -> new ProblemException((Problems)PROBLEMS.couldNotParseOption(choice)));
                for (StructDeclaration.Member member : struct.getMembers()) {
                    String value = this.makeRelativeIfNeeded(member.getExpression().toSource(), properties);
                    choices.add(new ParameterTemplate.Choice((Object)value, member.getName()));
                }
            }
        }
        if (config.containsKey(DEFAULT) && !config.get(DEFAULT).isEmpty()) {
            String value = config.get(DEFAULT).get(0);
            defaultValue = Optional.of(this.makeRelativeIfNeeded(value, properties));
        }
        return new ParameterTemplate(label, description, properties, choices, (Optional)defaultValue);
    }

    private String makeRelativeIfNeeded(String value, Set<ParameterProperty> properties) {
        boolean isFile;
        boolean bl = isFile = properties.contains((Object)TypedProperty.FILE) || properties.contains((Object)TypedProperty.BOOKMARK);
        if (isFile) {
            return UriHelper.makeRelativeToIfDotSlash((String)value, (URI)this.context.getRelativeTo());
        }
        return value;
    }

    private List<Problem> collectWarnings(ConfigSection section) {
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        Set spuriousKeys = section.toMultiMap().keySet().stream().filter(x -> !KEYS.contains(x)).collect(Collectors.toSet());
        if (!spuriousKeys.isEmpty()) {
            warnings.add(ConfigProblems.get().spuriousKeys(section, spuriousKeys));
        }
        return warnings;
    }

    @Override
    public ResultOrProblems<UserDefinedParameter> build(String id, ConfigSection section) {
        this.context = this.context.withNewRelativeTo(section.getLocation());
        return ProblemException.catching(() -> this.build(section.toMultiMap())).map(template -> UserDefinedParameter.wrap((String)id, (ParameterTemplate)template)).withMoreProblems(this.collectWarnings(section)).composeProblems(Problems.foundWith((Object)section, (Problem[])new Problem[0]));
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem couldNotParseOption(String var1);
    }
}

