/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.ini;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.IdentifiedException;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.model.IdentifiedModel;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class IniFileModelBuilder2
extends IdentifiedObjectBuilder.Base<IdentifiedModel> {
    private final Project project;
    private static final String DEFAULT_DESCRIPTION = "";
    public static final String MODEL_KEY = "model";

    public IniFileModelBuilder2(Project project) {
        super(IdentifiedModel.class, MODEL_KEY);
        this.project = project;
    }

    public ResultOrProblems<IdentifiedModel> buildModel(String modelName, ConfigSection section) {
        ModelFramework framework;
        LinkedList problems = new LinkedList();
        Consumer<List> addProblems = ps -> problems.addAll(ps);
        ResultOrProblems frameworkId = section.getOneRequired("framework");
        if (!frameworkId.isPresent()) {
            return ResultOrProblems.failed((List)frameworkId.getProblems());
        }
        String description = section.getOne("description").map(or -> (String)or.orElse(addProblems, null)).orElse(DEFAULT_DESCRIPTION);
        try {
            framework = (ModelFramework)this.project.getEngine().getModelFrameworks().get((String)frameworkId.get(), p -> problems.add(p));
        }
        catch (IdentifiedException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{e.getProblem()});
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        HashMap unbound = Maps.newHashMap((Map)section.toMultiMap());
        unbound.remove("framework");
        unbound.remove("description");
        BindingContext bindingContext = this.project.newBindingContext().withNewRelativeTo(section.getLocation());
        BoundParameters bound = framework.getBuildParameterSet().bind(bindingContext, ConfigSection.wild((Map)unbound));
        return bound.flatMap(buildParams -> framework.build(this.project, buildParams)).composeProblems((s, p) -> Problems.foundWith(IdentifiedModel.class, (String)modelName, (List)p)).map(model -> IdentifiedModel.wrap((String)modelName, (String)description, (Model)model));
    }

    @Override
    public ResultOrProblems<IdentifiedModel> build(String id, ConfigSection section) {
        return this.buildModel(id, section);
    }
}

