/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.ini;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.IdentifiedException;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class IniFileFunctionBuilder
extends IdentifiedObjectBuilder.Base<IdentifiedFunction> {
    private final Project project;
    public static final String FUNCTION_KEY = "function";
    public static final String FRAMEWORK_KEY = "framework";

    public IniFileFunctionBuilder(Project project) {
        super(IdentifiedFunction.class, FUNCTION_KEY);
        this.project = project;
    }

    private ResultOrProblems<IdentifiedFunction> buildFunction(String functionName, ConfigSection section) {
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        Map sectionValues = section.toMap();
        String frameworkId = sectionValues.getOrDefault(FRAMEWORK_KEY, this.getDefaultFrameworkId(section));
        if (frameworkId == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.required((String)FRAMEWORK_KEY, Parameter.class)});
        }
        FunctionFramework framework = null;
        try {
            framework = (FunctionFramework)this.project.getEngine().getFunctionFrameworks().get(frameworkId, p -> warnings.add(p));
        }
        catch (IdentifiedException ex) {
            return ResultOrProblems.error((RiskscapeException)((Object)ex));
        }
        BindingContext bindingContext = this.project.newBindingContext().withNewRelativeTo(section.getLocation());
        BoundParameters bound = framework.getParameterSet().bindConfig(bindingContext, section.toConfigMap());
        if (!bound.isValid()) {
            return ResultOrProblems.failed((List)bound.getValidationProblems());
        }
        if (!bound.getExtraneous().isEmpty()) {
            warnings.add(ConfigProblems.get().spuriousKeys(section, bound.getExtraneous().keySet()));
        }
        return framework.build(functionName, this.project, bound).withMoreProblems(warnings);
    }

    private String getDefaultFrameworkId(ConfigSection section) {
        ArrayList frameworks = new ArrayList(this.project.getEngine().getFunctionFrameworks().getAll());
        frameworks.sort((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
        for (FunctionFramework framework : frameworks) {
            if (!framework.canBuild(this.project, ConfigSection.wild((Map)section.toMultiMap()))) continue;
            return framework.getId();
        }
        return null;
    }

    @Override
    public ResultOrProblems<IdentifiedFunction> build(String id, ConfigSection section) {
        return this.buildFunction(id, section);
    }
}

