/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.MessageFactoryProxy;
import nz.org.riskscape.engine.i18n.MessageKey;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.ResourceBundleControl;

public class RiskscapeMessageSource
implements MessageSource {
    @Deprecated
    public static final Pattern MESSAGE_FORMAT_DETECTOR = Pattern.compile("(\\{\\d(\\s*,\\s*\\w+\\s*){0,2}\\})+");
    private final Function<Locale, ResourceBundle> resourceBundleFunction;

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(baseName, locale, classLoader, ResourceBundleControl.INSTANCE);
    }

    public RiskscapeMessageSource(String baseName, ClassLoader classLoader) {
        this(locale -> RiskscapeMessageSource.getBundle(baseName, locale, classLoader));
    }

    public String getMessage(MessageKey resolvable) {
        return this.getMessage(resolvable, Locale.getDefault());
    }

    public String getMessage(MessageKey resolvable, Locale locale) {
        String result;
        if (resolvable.getCode() != null && (result = this.getMessage(resolvable.getCode(), resolvable.getMessageArguments(), locale)) != null) {
            return result;
        }
        return this.formatIfNecessary(resolvable.getDefaultMessage(), resolvable.getMessageArguments(), locale);
    }

    public String getMessage(String code, Object ... args) {
        return this.getMessage(code, args, Locale.getDefault());
    }

    public String getMessage(String code, Object[] args, Locale locale) {
        return this.getMessage(code, args, null, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        ResourceBundle bundle = this.resourceBundleFunction.apply(locale);
        if (code != null && bundle.containsKey(code)) {
            return this.formatIfNecessary(bundle.getString(code), args, locale);
        }
        return this.formatIfNecessary(defaultMessage, args, locale);
    }

    String formatIfNecessary(String messageOrFormat, Object[] args, Locale locale) {
        if (Strings.isNullOrEmpty((String)messageOrFormat) || !MESSAGE_FORMAT_DETECTOR.matcher(messageOrFormat).find() || args == null || args.length == 0) {
            return messageOrFormat;
        }
        try {
            return new MessageFormat(messageOrFormat).format(this.resolveArguments(args, locale));
        }
        catch (IllegalArgumentException e) {
            return messageOrFormat;
        }
    }

    private Object[] resolveArguments(Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] processed = Arrays.copyOf(args, args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof MessageKey)) continue;
            processed[i] = this.getMessage((MessageKey)arg, locale);
        }
        return processed;
    }

    public ResourceBundle getBundle(Locale l) {
        return this.resourceBundleFunction.apply(l);
    }

    public <T extends MessageFactory> T getMessageFactory(Class<T> factory, Locale locale) {
        return (T)MessageFactoryProxy.getMessageFactory(factory, (Locale)locale, (MessageSource)this);
    }

    @Generated
    public RiskscapeMessageSource(Function<Locale, ResourceBundle> resourceBundleFunction) {
        this.resourceBundleFunction = resourceBundleFunction;
    }
}

