/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.I18nClassLoader;
import nz.org.riskscape.engine.i18n.MergedPropertiesResourceBundle;
import nz.org.riskscape.engine.i18n.ResourceClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleControl
extends ResourceBundle.Control {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleControl.class);
    public static final ResourceBundleControl INSTANCE = new ResourceBundleControl();
    public static final String PROPS_FILE_CHARSET = "UTF-8";

    @Override
    public List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMAT_PROPERTIES;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        List<URL> urls;
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        if (loader instanceof I18nClassLoader) {
            I18nClassLoader i18nLoader = (I18nClassLoader)loader;
            urls = i18nLoader.getResourcesByPrecedence(resourceName);
        } else if (loader instanceof ResourceClassLoader) {
            URL url = loader.getResource(resourceName);
            urls = url == null ? Collections.emptyList() : Collections.singletonList(url);
        } else {
            throw new IllegalArgumentException("Unsupported classloader - the riskscape ResourceBundleControl expects either an I18nClassLoader or a ResourceClassLoader, but we were given a " + String.valueOf(loader.getClass()));
        }
        log.info("Created resource bundle for base+locale {}+{} from {}", new Object[]{baseName, locale, urls});
        return new MergedPropertiesResourceBundle(urls, PROPS_FILE_CHARSET);
    }

    @Generated
    private ResourceBundleControl() {
    }
}

