/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergedPropertiesResourceBundle
extends ResourceBundle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergedPropertiesResourceBundle.class);
    private final List<URL> propsUrls;
    private final Properties cachedProperties = new Properties();
    private final List<Properties> searchThrough;

    MergedPropertiesResourceBundle(List<URL> propsUrls, String charsetName) throws UnsupportedEncodingException, IOException {
        this.propsUrls = propsUrls;
        this.searchThrough = new ArrayList<Properties>();
        for (URL url : propsUrls) {
            Properties props = new Properties();
            props.load(new InputStreamReader(url.openStream(), charsetName));
            this.searchThrough.add(props);
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.cachedProperties.computeIfAbsent(key, (Function<? super Object, ?>)((Function<Object, Object>)k -> this.searchFor(k)));
    }

    private Object searchFor(Object key) {
        log.debug("Looking for key {}", key);
        for (Properties props : this.searchThrough) {
            Object found = props.get(key);
            if (found == null) continue;
            log.debug("Found key in {}", (Object)this.propsUrls.get(this.searchThrough.indexOf(props)));
            return found;
        }
        return null;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.getAllKeys());
    }

    protected Set<String> getAllKeys() {
        HashSet<String> combined = new HashSet<String>();
        for (Properties properties : this.searchThrough) {
            for (Object key : properties.keySet()) {
                combined.add(key.toString());
            }
        }
        if (this.parent != null) {
            combined.addAll(((MergedPropertiesResourceBundle)this.parent).getAllKeys());
        }
        return combined;
    }
}

