/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nClassLoader
extends ClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nClassLoader.class);
    private final List<Pair> searchList = new ArrayList<Pair>();

    public void append(Object owner, ClassLoader loader) {
        Pair pair = new Pair(owner, loader);
        this.searchList.add(pair);
        this.invalidateCache(pair);
    }

    public void unshift(Object owner, ClassLoader loader) {
        Pair pair = new Pair(owner, loader);
        this.searchList.add(0, pair);
        this.invalidateCache(pair);
    }

    public boolean insertBefore(Object owner, ClassLoader loader, BiPredicate<Object, ClassLoader> searchMethod) {
        return this.insert(true, owner, loader, searchMethod);
    }

    public boolean insertAfter(Object owner, ClassLoader loader, BiPredicate<Object, ClassLoader> searchMethod) {
        return this.insert(false, owner, loader, searchMethod);
    }

    private boolean insert(boolean before, Object owner, ClassLoader loader, BiPredicate<Object, ClassLoader> searchMethod) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            Pair pair = this.searchList.get(i);
            if (!searchMethod.test(pair.owner, pair.loader)) continue;
            Pair newPair = new Pair(owner, loader);
            this.searchList.add(before ? i : i + 1, newPair);
            this.invalidateCache(newPair);
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Pair pair : this.searchList) {
            try {
                return pair.loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassCastException(name + " not found among any of " + String.valueOf(this.searchList));
    }

    @Override
    public URL getResource(String name) {
        for (Pair pair : this.searchList) {
            URL resource = pair.loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public List<URL> getResourcesByPrecedence(String name) {
        ArrayList<URL> allUrls = new ArrayList<URL>();
        for (Pair pair : this.searchList) {
            URL subResource = pair.loader.getResource(name);
            if (subResource == null) continue;
            allUrls.add(subResource);
        }
        log.debug("Search for {} found {}", (Object)name, allUrls);
        return allUrls;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> allUrls = new ArrayList<URL>();
        for (Pair pair : this.searchList) {
            Enumeration<URL> subResources = pair.loader.getResources(name);
            while (subResources.hasMoreElements()) {
                allUrls.add(subResources.nextElement());
            }
        }
        return Collections.enumeration(allUrls);
    }

    private void invalidateCache(Pair pair) {
        log.debug("Invalidating resource bundle cache for {} because of {}", (Object)this, (Object)pair);
        ResourceBundle.clearCache(this);
    }

    private static class Pair {
        final Object owner;
        final ClassLoader loader;

        @Generated
        public Pair(Object owner, ClassLoader loader) {
            this.owner = owner;
            this.loader = loader;
        }

        @Generated
        public Object getOwner() {
            return this.owner;
        }

        @Generated
        public ClassLoader getLoader() {
            return this.loader;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$owner = this.getOwner();
            Object other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            ClassLoader this$loader = this.getLoader();
            ClassLoader other$loader = other.getLoader();
            return !(this$loader == null ? other$loader != null : !this$loader.equals(other$loader));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            ClassLoader $loader = this.getLoader();
            result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "I18nClassLoader.Pair(owner=" + String.valueOf(this.getOwner()) + ", loader=" + String.valueOf(this.getLoader()) + ")";
        }
    }
}

