/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.TranslationContext;

public class EnumTranslator {
    private final TranslationContext context;

    public <T extends Enum<?>> List<EnumEntry<T>> getEntries(Class<T> enumClass) {
        ArrayList<EnumEntry<T>> entries = new ArrayList<EnumEntry<T>>();
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            entries.add(new EnumEntry(this, value));
        }
        return entries;
    }

    public <T extends Enum<?>> EnumEntry<T> getEntry(T enumValue) {
        return new EnumEntry(this, enumValue);
    }

    @Generated
    public EnumTranslator(TranslationContext context) {
        this.context = context;
    }

    public static class EnumEntry<T extends Enum<?>> {
        private final T value;
        final /* synthetic */ EnumTranslator this$0;

        public String getLabel(Object ... args) {
            String label = this.this$0.context.getMessage(this.getCode(), args);
            if (label == null) {
                label = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, ((Enum)this.value).name());
            }
            return label;
        }

        public String getLabelOr(String defaultMessage, Object ... args) {
            String label = this.this$0.context.getMessage(this.getCode(), args);
            if (label == null) {
                label = defaultMessage;
            }
            return label;
        }

        public String getCode() {
            return this.value.getClass().getCanonicalName() + "." + ((Enum)this.value).name();
        }

        public String getDescription(Object ... args) {
            return this.this$0.context.getMessage(this.getCode() + ".description", args);
        }

        @Generated
        public EnumEntry(T value) {
            this.this$0 = this$0;
            this.value = value;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumEntry)) {
                return false;
            }
            EnumEntry other = (EnumEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EnumEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EnumTranslator.EnumEntry(value=" + String.valueOf(this.getValue()) + ")";
        }
    }
}

