/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Range;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.ini.IniConfigSection;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.auth.HttpSecret;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.geo.GeometryRenderer;
import nz.org.riskscape.engine.i18n.MessageKey;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.i18n.ObjectRenderer;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.StepDefinition;
import nz.org.riskscape.pipeline.ast.StepReference;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.StructDeclaration;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.ini4j.Profile;

public class DefaultObjectRenderer
implements ObjectRenderer {
    private final List<ObjectRenderer> renderers = this.buildRenderers();

    public String render(Messages messages, Object object) {
        return this.render(messages, object, Locale.getDefault()).orElse(null);
    }

    public Optional<String> render(Messages messages, Object object, Locale locale) {
        if (object instanceof Collection) {
            return Optional.of(this.renderCollection(messages, (Collection)object, locale));
        }
        for (ObjectRenderer renderer : this.renderers) {
            Optional rendered = renderer.render(messages, object, locale);
            if (!rendered.isPresent()) continue;
            return rendered;
        }
        return Optional.of(String.valueOf(object));
    }

    private String renderCollection(Messages messages, Collection<?> collection, Locale locale) {
        return collection.stream().flatMap(item -> this.render(messages, item, locale).stream()).collect(Collectors.joining(", ", "[", "]"));
    }

    private List<ObjectRenderer> buildRenderers() {
        return Arrays.asList(new MessageKeyRenderer<Class>(Class.class, clazz -> new MessageKeyImpl(clazz.getCanonicalName() + ".class", DefaultObjectRenderer.getDisplayName(clazz), new Object[0])), new MessageKeyRenderer<MessageKey>(MessageKey.class, key -> key), new MessageKeyRenderer<ProblemPlaceholder>(ProblemPlaceholder.class, id -> this.problemPlaceholderToKey((ProblemPlaceholder)id)), new MessageKeyRenderer<Bookmark>(Bookmark.class, bookmark -> this.bookmarkToKey((Bookmark)bookmark)), new MessageKeyRenderer<Parameter>(Parameter.class, param -> this.namedClassToKey(Parameter.class, param.getName())), new StringRenderer<HttpSecret>(HttpSecret.class, (secret, messages, locale) -> {
            if (secret.getDefinedIn() == Resource.UNKNOWN_URI) {
                return messages.getProblems().getMessage(this.toSubMessageKey(HttpSecret.class, "noLocation", "''{0}'' {1} secret", secret.getId(), secret.getFramework()));
            }
            return messages.getProblems().getMessage(this.toSubMessageKey(HttpSecret.class, "withLocation", "''{0}'' {1} secret from {2}", secret.getId(), secret.getFramework(), this.formatUri(messages, secret.getDefinedIn(), locale)));
        }), new MessageKeyRenderer<IdentifiedFunction>(IdentifiedFunction.class, function -> this.functionToKey((IdentifiedFunction)function)), new MessageKeyRenderer<Identified>(Identified.class, id -> this.namedClassToKey(id.getIdentifiedClass(), id.getId())), new MessageKeyRenderer<StepDefinition>(StepDefinition.class, step -> this.toMessageKey(StepDefinition.class, "{0}", this.getSourceFragment((StepDefinition)step))), new MessageKeyRenderer<RealizedStep>(RealizedStep.class, step -> this.toMessageKey(StepDefinition.class, "{0}", this.getSourceFragment(step.getAst()))), new MessageKeyRenderer<StepReference>(StepReference.class, step -> this.namedClassToKey(StepReference.class, step.getIdent())), new MessageKeyRenderer<Model>(Model.class, model -> this.toMessageKey(Model.class, "{0} model", model.getFramework().getId())), new StringRenderer<Resource>(Resource.class, (resource, messages, locale) -> this.formatUri(messages, resource.getLocation(), locale)), new StringRenderer<URI>(URI.class, (uri, messages, locale) -> this.formatUri(messages, (URI)uri, locale)), new MessageKeyRenderer<Token>(Token.class, token -> this.tokenToKey((Token)token)), new MessageKeyRenderer<ReferencedEnvelope>(ReferencedEnvelope.class, env -> this.toMessageKey(ReferencedEnvelope.class, GeometryRenderer.getBounds(env), new Object[0])), new MessageKeyRenderer<CoordinateReferenceSystem>(CoordinateReferenceSystem.class, crs -> this.toMessageKey(CoordinateReferenceSystem.class, GeometryRenderer.getCode(crs), new Object[0])), new MessageKeyRenderer<FunctionArgument>(FunctionArgument.class, arg -> this.functionArgToKey((FunctionArgument)arg)), new MessageKeyRenderer<FunctionCall.Argument>(FunctionCall.Argument.class, arg -> this.namedClassToKey(FunctionCall.Argument.class, arg.toSource())), new MessageKeyRenderer<Struct.StructMember>(Struct.StructMember.class, member -> this.toMessageKey(member.getClass(), "''{0}: {1}'' struct member", member.getKey(), member.getType())), new MessageKeyRenderer<Expression>(Expression.class, expr -> this.namedClassToKey(Expression.class, expr.toSource())), new MessageKeyRenderer<PipelineDeclaration>(PipelineDeclaration.class, decl -> this.namedClassToKey(PipelineDeclaration.class, decl.toSource())), new MessageKeyRenderer<StructDeclaration.Member>(StructDeclaration.Member.class, ad -> this.toMessageKey(StructDeclaration.Member.class, ad.toSource(), ad.toSource())), new MessageKeyRenderer<Profile.Section>(Profile.Section.class, section -> this.namedClassToKey(Profile.Section.class, section.getName())), new StringRenderer<IniConfigSection>(IniConfigSection.class, (section, messages, locale) -> {
            String uri = this.formatUri(messages, section.getLocation(), locale);
            return messages.getProblems().getMessage(IniConfigSection.class.getCanonicalName(), new Object[]{section.getName(), uri}, "INI file section ''[{0}]'' on {1}", locale);
        }), new MessageKeyRenderer<Range>(Range.class, range -> this.toMessageKey(Range.class, this.displayRange((Range<?>)range), new Object[0])), new MessageKeyRenderer<ParameterProperty>(ParameterProperty.class, property -> this.namedClassToKey(ParameterProperty.class, property.getKeyword())), (object, messages, locale) -> Optional.empty());
    }

    private Object getSourceFragment(StepDefinition ast) {
        String stepIdentity = "`" + ast.getIdent() + "` step";
        if (ast.getName().isPresent()) {
            stepIdentity = stepIdentity + " (" + (String)ast.getName().get() + ")";
        }
        if (ast.getIdentToken().getLocation().getLine() > 0) {
            return stepIdentity + " on line " + ast.getIdentToken().getLocation().getLine();
        }
        return stepIdentity;
    }

    private String displayRange(Range<?> range) {
        if (!range.hasLowerBound()) {
            return range.toString();
        }
        if (range.hasUpperBound()) {
            if (range.lowerEndpoint().equals(range.upperEndpoint())) {
                return range.lowerEndpoint().toString();
            }
            return String.valueOf(range.lowerEndpoint()) + "-" + String.valueOf(range.upperEndpoint());
        }
        return String.valueOf(range.lowerEndpoint()) + "+";
    }

    private String formatUri(Messages messages, URI uri, Locale locale) {
        String uriAsString;
        SourceLocation loc = SourceLocation.parseUriFragment((String)uri.getFragment()).orElse(null);
        if ("file".equals(uri.getScheme())) {
            uriAsString = uri.getPath();
        } else {
            uriAsString = uri.toString();
            if (loc != null) {
                uriAsString = uriAsString.substring(0, uriAsString.indexOf(35));
            }
        }
        if (loc == null) {
            return uriAsString;
        }
        if (loc.isUnlined()) {
            return messages.getProblems().getMessage(URI.class.getCanonicalName() + ".unlined", new Object[]{uriAsString, loc.getIndex() + 1}, "{0}", locale);
        }
        return messages.getProblems().getMessage(URI.class.getCanonicalName() + ".lined", new Object[]{uriAsString, loc.getLine()}, "{0}", locale);
    }

    private static String getDisplayName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.isEmpty()) {
            className = clazz.getName();
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className).replace("_", " ");
    }

    private MessageKey toMessageKey(Class<?> clazz, String defaultMessage, Object ... args) {
        return new MessageKeyImpl(clazz.getCanonicalName(), defaultMessage, args);
    }

    private MessageKey toSubMessageKey(Class<?> clazz, String subMessageKey, String defaultMessage, Object ... args) {
        return new MessageKeyImpl(clazz.getCanonicalName() + "." + subMessageKey, defaultMessage, args);
    }

    private MessageKey namedClassToKey(Class<?> clazz, String name) {
        return this.toMessageKey(clazz, String.format("''{0}'' %s", DefaultObjectRenderer.getDisplayName(clazz)), name);
    }

    private MessageKey problemPlaceholderToKey(ProblemPlaceholder thing) {
        Class classToRender = thing.getWrappedClass();
        if (Identified.class.isAssignableFrom(classToRender)) {
            classToRender = thing.getIdentifiedClass();
        }
        return this.namedClassToKey(classToRender, thing.getId());
    }

    private MessageKey tokenToKey(Token token) {
        if (token == Token.UNKNOWN_LOCATION) {
            return new MessageKeyImpl(token.getClass().getCanonicalName() + ".UNKNOWN_LOCATION", "<unknown location>", null);
        }
        if (token.isSourceSingleLine()) {
            return new MessageKeyImpl(token.getClass().getCanonicalName() + ".singleLine", "''{0}''", new Object[]{token.getValue()});
        }
        return this.toMessageKey(token.getClass(), "''{0}'' on line {1} (column {2})", token.getValue(), token.getLocation().getLine(), token.getLocation().getColumn());
    }

    private MessageKey functionArgToKey(FunctionArgument arg) {
        if (arg.hasKeyword()) {
            return this.namedClassToKey(arg.getClass(), arg.getKeyword());
        }
        return new MessageKeyImpl(arg.getClass().getCanonicalName() + ".numbered", "function argument {0}", new Object[]{arg.getIndex() + 1});
    }

    private MessageKey bookmarkToKey(Bookmark bookmark) {
        if (bookmark.isFromURI() || bookmark.getLocation() == null) {
            return this.namedClassToKey(Bookmark.class, bookmark.getId());
        }
        return new MessageKeyImpl(Bookmark.class.getName() + ".location", "''{0}'' bookmark in location {1}", new Object[]{bookmark.getId(), bookmark.getLocation()});
    }

    private MessageKey functionToKey(IdentifiedFunction function) {
        if (function.getSourceURI() == Resource.UNKNOWN_URI || function.isBuiltin()) {
            return this.namedClassToKey(IdentifiedFunction.class, function.getId());
        }
        return new MessageKeyImpl(IdentifiedFunction.class.getName() + ".withSource", "''{0}'' function (from source {1})", new Object[]{function.getId(), function.getSource()});
    }

    private class MessageKeyRenderer<T>
    implements ObjectRenderer {
        private final Class<T> forClass;
        private final Function<T, MessageKey> converter;

        public boolean canDisplay(Object object) {
            return object != null && this.forClass.isAssignableFrom(object.getClass());
        }

        public Optional<String> render(Messages messages, Object object, Locale locale) {
            if (this.canDisplay(object)) {
                MessageKey key = this.converter.apply(this.forClass.cast(object));
                return Optional.of(messages.getProblems().getMessage(key, locale));
            }
            return Optional.empty();
        }

        @Generated
        public MessageKeyRenderer(Class<T> forClass, Function<T, MessageKey> converter) {
            this.forClass = forClass;
            this.converter = converter;
        }
    }

    private static class StringRenderer<T>
    implements ObjectRenderer {
        private final Class<T> forClass;
        private final RenderFunction<T> renderer;

        public Optional<String> render(Messages messages, Object object, Locale locale) {
            if (object != null && this.forClass.isAssignableFrom(object.getClass())) {
                return Optional.of(this.renderer.apply(this.forClass.cast(object), messages, locale));
            }
            return Optional.empty();
        }

        @Generated
        public StringRenderer(Class<T> forClass, RenderFunction<T> renderer) {
            this.forClass = forClass;
            this.renderer = renderer;
        }
    }

    private static interface RenderFunction<T> {
        public String apply(T var1, Messages var2, Locale var3);
    }

    private class MessageKeyImpl
    implements MessageKey {
        private final String code;
        private final String defaultMessage;
        private final Object[] messageArguments;

        @Generated
        public MessageKeyImpl(String code, String defaultMessage, Object[] messageArguments) {
            this.code = code;
            this.defaultMessage = defaultMessage;
            this.messageArguments = messageArguments;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDefaultMessage() {
            return this.defaultMessage;
        }

        @Generated
        public Object[] getMessageArguments() {
            return this.messageArguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageKeyImpl)) {
                return false;
            }
            MessageKeyImpl other = (MessageKeyImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$defaultMessage = this.getDefaultMessage();
            String other$defaultMessage = other.getDefaultMessage();
            if (this$defaultMessage == null ? other$defaultMessage != null : !this$defaultMessage.equals(other$defaultMessage)) {
                return false;
            }
            return Arrays.deepEquals(this.getMessageArguments(), other.getMessageArguments());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MessageKeyImpl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $defaultMessage = this.getDefaultMessage();
            result = result * 59 + ($defaultMessage == null ? 43 : $defaultMessage.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getMessageArguments());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultObjectRenderer.MessageKeyImpl(code=" + this.getCode() + ", defaultMessage=" + this.getDefaultMessage() + ", messageArguments=" + Arrays.deepToString(this.getMessageArguments()) + ")";
        }
    }
}

