/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.i18n.DefaultObjectRenderer;
import nz.org.riskscape.engine.i18n.HasMessages;
import nz.org.riskscape.engine.i18n.I18nClassLoader;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.i18n.ObjectRenderer;
import nz.org.riskscape.engine.i18n.RenderedProblem;
import nz.org.riskscape.engine.i18n.ResourceBundleControl;
import nz.org.riskscape.engine.i18n.RiskscapeMessageSource;
import nz.org.riskscape.engine.plugin.ExtensionPoints;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.StandardCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessages
implements Messages {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMessages.class);
    protected final I18nClassLoader classLoader;
    protected final ResourceBundleControl control;
    private final RiskscapeMessageSource help;
    private final RiskscapeMessageSource labels;
    private final RiskscapeMessageSource problems;
    private Locale defaultLocale = Locale.getDefault();
    private final DefaultObjectRenderer objectRenderer;
    private final ExtensionPoints extensionPoints;

    public static String getCode(Identified object, String ... parts) {
        return DefaultMessages.getCode(object.getIdentifiedClass().getName(), object.getId(), parts);
    }

    public static String getShortCode(Identified object, String ... parts) {
        return DefaultMessages.getCode(object.getIdentifiedClass().getSimpleName(), object.getId(), parts);
    }

    public static String getCode(String className, String id, String ... parts) {
        StringBuilder builder = new StringBuilder();
        DefaultMessages.key(builder, className, "by-id", id);
        DefaultMessages.key(builder, parts);
        return builder.toString();
    }

    private static StringBuilder key(StringBuilder builder, String ... parts) {
        for (String string : parts) {
            if (builder.length() != 0) {
                builder.append(".");
            }
            builder.append(string);
        }
        return builder;
    }

    DefaultMessages(Map<String, ResourceBundle> bundles, DefaultObjectRenderer renderer, ExtensionPoints eps) {
        this.classLoader = new I18nClassLoader();
        this.control = ResourceBundleControl.INSTANCE;
        this.help = new RiskscapeMessageSource(l -> (ResourceBundle)bundles.get("help"));
        this.labels = new RiskscapeMessageSource(l -> (ResourceBundle)bundles.get("labels"));
        this.problems = new RiskscapeMessageSource(l -> (ResourceBundle)bundles.get("problems"));
        this.objectRenderer = renderer;
        this.extensionPoints = eps;
    }

    public DefaultMessages(ExtensionPoints extensionPoints) {
        this.classLoader = new I18nClassLoader();
        this.control = ResourceBundleControl.INSTANCE;
        this.help = this.newMessageSource("help");
        this.labels = this.newMessageSource("labels");
        this.problems = this.newMessageSource("problems");
        this.objectRenderer = new DefaultObjectRenderer();
        this.extensionPoints = extensionPoints;
    }

    public RiskscapeMessageSource newMessageSource(String baseName) {
        return new RiskscapeMessageSource(baseName, this.classLoader);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return this.newMessageSource(baseName).getBundle(locale);
    }

    private String findMessageById(MessageSource msgs, Locale locale, Identified object, String ... parts) {
        String byIdKey = DefaultMessages.getCode(object, parts);
        String result = msgs.getMessage(byIdKey, null, locale);
        if (result == null) {
            result = msgs.getMessage(DefaultMessages.getShortCode(object, parts), null, locale);
        }
        return result;
    }

    private String findMessageByInstance(MessageSource msgs, Locale locale, Identified object, String ... parts) {
        String lookedUp = this.findMessageById(msgs, locale, object, parts);
        if (lookedUp != null) {
            return lookedUp;
        }
        return this.findMessageByClass(msgs, locale, object.getClass(), parts);
    }

    public Optional<String> getMessage(MessageSource msgs, Locale locale, @NonNull Object owner, String ... parts) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (owner instanceof Identified) {
            return Optional.ofNullable(this.findMessageByInstance(msgs, locale, (Identified)owner, parts));
        }
        if (owner instanceof Class) {
            return Optional.ofNullable(this.findMessageByClass(msgs, locale, (Class)owner, parts));
        }
        return Optional.ofNullable(this.findMessageByClass(msgs, locale, owner.getClass(), parts));
    }

    private String[] appendToParts(String[] origParts, int toAdd) {
        String[] newParts = new String[origParts.length + 1];
        System.arraycopy(origParts, 0, newParts, 0, origParts.length);
        newParts[origParts.length] = Integer.toString(toAdd);
        return newParts;
    }

    public List<String> getDetailedMessage(MessageSource msgs, Locale locale, Object owner, String ... parts) {
        ArrayList<String> results = new ArrayList<String>();
        String lookup = this.getMessage(msgs, locale, owner, parts).orElse(null);
        int i = 1;
        while (lookup != null) {
            results.add(lookup);
            lookup = this.getMessage(msgs, locale, owner, this.appendToParts(parts, i++)).orElse(null);
        }
        return results;
    }

    private String findMessageByClass(MessageSource msgs, Locale locale, Class<?> owner, String ... parts) {
        StringBuilder builder = new StringBuilder();
        DefaultMessages.key(builder, owner.getCanonicalName());
        DefaultMessages.key(builder, parts);
        String result = msgs.getMessage(builder.toString(), null, locale);
        if (result == null && owner.getSuperclass() != Object.class) {
            return this.findMessageByClass(msgs, locale, owner.getSuperclass(), parts);
        }
        return result;
    }

    public Set<String> getKnownBundleNames(ExtensionPoints eps) {
        ImmutableSet wellKnownBundles = ImmutableSet.of((Object)"help", (Object)"labels", (Object)"problems");
        Set fromPlugins = eps.getFeaturesOfType(HasMessages.class).stream().map(hm -> hm.getBundleName()).collect(Collectors.toSet());
        return ImmutableSet.builder().addAll((Iterable)wellKnownBundles).addAll(fromPlugins).build();
    }

    public String renderObject(Object object, Locale locale) {
        for (ObjectRenderer renderer : this.extensionPoints.getFeaturesOfType(ObjectRenderer.class)) {
            String rendered = renderer.render((Messages)this, object, locale).orElse(null);
            if (rendered == null) continue;
            return rendered;
        }
        return this.objectRenderer.render(this, object, locale).orElse(null);
    }

    public RenderedProblem renderProblem(Problem problem, Locale locale) {
        return this.renderProblem(problem, locale, 0);
    }

    private RenderedProblem renderProblem(Problem problem, Locale locale, int nesting) {
        String message;
        if (problem.getCode() != StandardCodes.NONE) {
            message = this.problems.getMessage(problem.getCode().toKey(), (Object[])this.getRenderedArguments(problem, locale), locale);
            if (message == null) {
                log.warn("Possible missing i18n key - {}", (Object)problem.getCode().toKey());
                message = problem.getDefaultMessage();
            }
        } else {
            message = problem.getDefaultMessage();
        }
        ArrayList<RenderedProblem> children = new ArrayList<RenderedProblem>(problem.getChildren().size());
        for (Problem child : problem.getChildren()) {
            children.add(this.renderProblem(child, locale, nesting + 1));
        }
        return new RenderedProblem(message, problem, nesting, Collections.unmodifiableList(children));
    }

    private String[] getRenderedArguments(Problem problem, Locale locale) {
        Object[] args = problem.getArguments();
        String[] renderedArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            renderedArgs[i] = this.renderObject(args[i], locale);
        }
        return renderedArgs;
    }

    public void addPluginResources(Plugin plugin) {
        this.classLoader.append(plugin, plugin.getI18nClassLoader());
    }

    @Generated
    public DefaultMessages(I18nClassLoader classLoader, ResourceBundleControl control, RiskscapeMessageSource help, RiskscapeMessageSource labels, RiskscapeMessageSource problems, DefaultObjectRenderer objectRenderer, ExtensionPoints extensionPoints) {
        this.classLoader = classLoader;
        this.control = control;
        this.help = help;
        this.labels = labels;
        this.problems = problems;
        this.objectRenderer = objectRenderer;
        this.extensionPoints = extensionPoints;
    }

    @Generated
    public I18nClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public ResourceBundleControl getControl() {
        return this.control;
    }

    @Generated
    public RiskscapeMessageSource getHelp() {
        return this.help;
    }

    @Generated
    public RiskscapeMessageSource getLabels() {
        return this.labels;
    }

    @Generated
    public RiskscapeMessageSource getProblems() {
        return this.problems;
    }

    @Generated
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Generated
    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

