/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.gt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nz.org.riskscape.engine.Unchecked;
import nz.org.riskscape.engine.expr.TypedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;

public class FilterValidator {
    public static final FilterValidator INSTANCE = new FilterValidator();

    public List<Problem> validateFilter(final Struct struct, Filter filter) {
        final ArrayList<Problem> problems = new ArrayList<Problem>();
        filter.accept(new FilterVisitor(){

            public Object visitNullFilter(Object extraData) {
                return null;
            }

            private Object unsupported(Object message) {
                problems.add(new Unchecked("Unsupported filter - " + String.valueOf(message)));
                return null;
            }

            public Object visit(TOverlaps contains, Object extraData) {
                return this.check((BinaryTemporalOperator)contains);
            }

            private Boolean check(BinaryTemporalOperator contains) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, contains.getExpression1()).getProblems());
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, contains.getExpression2()).getProblems());
                return null;
            }

            public Object visit(TEquals equals, Object extraData) {
                return this.check((BinaryTemporalOperator)equals);
            }

            public Object visit(TContains contains, Object extraData) {
                return this.check((BinaryTemporalOperator)contains);
            }

            public Object visit(OverlappedBy overlappedBy, Object extraData) {
                return this.check((BinaryTemporalOperator)overlappedBy);
            }

            public Object visit(MetBy metBy, Object extraData) {
                return this.check((BinaryTemporalOperator)metBy);
            }

            public Object visit(Meets meets, Object extraData) {
                return this.check((BinaryTemporalOperator)meets);
            }

            public Object visit(Ends ends, Object extraData) {
                return this.check((BinaryTemporalOperator)ends);
            }

            public Object visit(EndedBy endedBy, Object extraData) {
                return this.check((BinaryTemporalOperator)endedBy);
            }

            public Object visit(During during, Object extraData) {
                return this.check((BinaryTemporalOperator)during);
            }

            public Object visit(BegunBy begunBy, Object extraData) {
                return this.check((BinaryTemporalOperator)begunBy);
            }

            public Object visit(Begins begins, Object extraData) {
                return this.check((BinaryTemporalOperator)begins);
            }

            public Object visit(Before before, Object extraData) {
                return this.check((BinaryTemporalOperator)before);
            }

            public Object visit(AnyInteracts anyInteracts, Object extraData) {
                return this.check((BinaryTemporalOperator)anyInteracts);
            }

            public Object visit(After after, Object extraData) {
                return this.check((BinaryTemporalOperator)after);
            }

            public Object visit(Within filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            private Object check(BinarySpatialOperator filter) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression1()).getProblems());
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression2()).getProblems());
                return null;
            }

            public Object visit(Touches filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Overlaps filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Intersects filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Equals filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(DWithin filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Disjoint filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Crosses filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Contains filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(Beyond filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(BBOX filter, Object extraData) {
                return this.check((BinarySpatialOperator)filter);
            }

            public Object visit(PropertyIsNil filter, Object extraData) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression()).getProblems());
                return null;
            }

            public Object visit(PropertyIsNull filter, Object extraData) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression()).getProblems());
                return null;
            }

            public Object visit(PropertyIsLike filter, Object extraData) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression()).getProblems());
                return null;
            }

            public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            private Object check(BinaryComparisonOperator filter) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression1()).getProblems());
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression2()).getProblems());
                return null;
            }

            public Object visit(PropertyIsLessThan filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            public Object visit(PropertyIsGreaterThan filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            public Object visit(PropertyIsEqualTo filter, Object extraData) {
                return this.check((BinaryComparisonOperator)filter);
            }

            public Object visit(PropertyIsBetween filter, Object extraData) {
                problems.addAll(FilterValidator.this.validateExpression((Type)struct, filter.getExpression()).getProblems());
                return null;
            }

            public Object visit(Or filter, Object extraData) {
                return this.check((BinaryLogicOperator)filter);
            }

            private Object check(BinaryLogicOperator filter) {
                for (Filter child : filter.getChildren()) {
                    child.accept((FilterVisitor)this, null);
                }
                return null;
            }

            public Object visit(Not filter, Object extraData) {
                return filter.getFilter().accept((FilterVisitor)this, null);
            }

            public Object visit(Id filter, Object extraData) {
                return this.unsupported(filter);
            }

            public Object visit(And filter, Object extraData) {
                return this.check((BinaryLogicOperator)filter);
            }

            public Object visit(IncludeFilter filter, Object extraData) {
                return Boolean.TRUE;
            }

            public Object visit(ExcludeFilter filter, Object extraData) {
                return Boolean.TRUE;
            }
        }, null);
        return problems;
    }

    public ResultOrProblems<Type> validateExpression(final Type type, Expression expression) {
        final ArrayList problems = new ArrayList();
        Type returnType = (Type)expression.accept(new ExpressionVisitor(){
            private List<Type> typeRanking = Lists.newArrayList((Object[])new Type[]{Types.ANYTHING, Types.INTEGER, Types.FLOATING, Types.DECIMAL});

            public Object visit(Subtract expression, Object extraData) {
                return this.check((BinaryExpression)expression);
            }

            private Object check(BinaryExpression expression) {
                Type t1 = (Type)expression.getExpression1().accept((ExpressionVisitor)this, null);
                Type t2 = (Type)expression.getExpression2().accept((ExpressionVisitor)this, null);
                int x = this.typeRanking.indexOf(t1) - this.typeRanking.indexOf(t2);
                if (x >= 0) {
                    return t1;
                }
                return t2;
            }

            public Object visit(PropertyName expression, Object extraData) {
                if (expression instanceof TypedExpression) {
                    ResultOrProblems<Type> typeResult = ((TypedExpression)expression).evaluateType(type);
                    problems.addAll(typeResult.getProblems());
                    if (typeResult.isPresent()) {
                        return typeResult.get();
                    }
                }
                return Types.ANYTHING;
            }

            public Object visit(Multiply expression, Object extraData) {
                return this.check((BinaryExpression)expression);
            }

            public Object visit(Literal expression, Object extraData) {
                if (expression instanceof TypedExpression) {
                    ResultOrProblems<Type> typeResult = ((TypedExpression)expression).evaluateType(type);
                    problems.addAll(typeResult.getProblems());
                    if (typeResult.isPresent()) {
                        return typeResult.get();
                    }
                }
                return Types.ANYTHING;
            }

            public Object visit(Function expression, Object extraData) {
                if (expression instanceof TypedExpression) {
                    ResultOrProblems<Type> typeResult = ((TypedExpression)expression).evaluateType(type);
                    problems.addAll(typeResult.getProblems());
                    if (typeResult.isPresent()) {
                        return typeResult.get();
                    }
                } else {
                    for (Expression child : expression.getParameters()) {
                        child.accept((ExpressionVisitor)this, null);
                    }
                }
                return this.findReturnType(expression);
            }

            private Type findReturnType(Function expression) {
                Class functionReturnClass = Object.class;
                if (expression.getFunctionName() != null && expression.getFunctionName().getReturn() != null) {
                    functionReturnClass = expression.getFunctionName().getReturn().getType();
                }
                if (expression.getName().equals("if_then_else")) {
                    return this.findIfThenElseReturnType(expression);
                }
                return (Type)Types.fromJavaTypeOptional(functionReturnClass).orElse(Types.ANYTHING);
            }

            private Type findIfThenElseReturnType(Function expression) {
                Type foundElse;
                Expression thenExpression = (Expression)expression.getParameters().get(1);
                Expression elseExpression = (Expression)expression.getParameters().get(2);
                Type foundThen = (Type)thenExpression.accept((ExpressionVisitor)this, null);
                if (foundThen.equals(foundElse = (Type)elseExpression.accept((ExpressionVisitor)this, null))) {
                    return foundThen;
                }
                Object notNullable = Nullable.unwrap((Type)foundThen).equals(Nullable.unwrap((Type)foundElse)) ? foundElse : Types.ANYTHING;
                return foundElse.find(Nullable.class).map(arg_0 -> 2.lambda$findIfThenElseReturnType$0((Type)notNullable, arg_0)).orElse((Type)notNullable);
            }

            public Object visit(Divide expression, Object extraData) {
                this.check((BinaryExpression)expression);
                return Types.FLOATING;
            }

            public Object visit(Add expression, Object extraData) {
                return this.check((BinaryExpression)expression);
            }

            public Object visit(NilExpression expression, Object extraData) {
                return Types.ANYTHING;
            }

            private static /* synthetic */ Type lambda$findIfThenElseReturnType$0(Type notNullable, Nullable n) {
                return Nullable.of((Type)notNullable);
            }
        }, null);
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of((Object)returnType, problems);
    }
}

