/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.gt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.spatial.BBOXImpl;

public class ConvertFilter
implements ExpressionVisitor,
FilterVisitor {
    public final FilterFactory filterFactory;

    public ConvertFilter() {
        this.filterFactory = CommonFactoryFinder.getFilterFactory();
    }

    public ConvertFilter(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.filterFactory.multiply((Expression)expression.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)expression.getExpression2().accept((ExpressionVisitor)this, extraData));
    }

    protected boolean supportsVisitSpatialOperator() {
        return false;
    }

    protected Object visitSpatialOperator(BinarySpatialOperator operator, Object extraData) {
        return null;
    }

    public Object visit(Literal expression, Object extraData) {
        return expression;
    }

    public Object visit(Function expression, Object extraData) {
        List<Expression> newArgs = expression.getParameters().stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)this, extraData)).collect(Collectors.toList());
        return this.filterFactory.function(expression.getName(), newArgs.toArray(new Expression[0]));
    }

    public Object visit(Divide expression, Object extraData) {
        return this.filterFactory.divide((Expression)expression.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)expression.getExpression2().accept((ExpressionVisitor)this, extraData));
    }

    public Object visit(Add expression, Object extraData) {
        return this.filterFactory.add((Expression)expression.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)expression.getExpression2().accept((ExpressionVisitor)this, extraData));
    }

    public Object visit(NilExpression expression, Object extraData) {
        return expression;
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.filterFactory.subtract((Expression)expression.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)expression.getExpression2().accept((ExpressionVisitor)this, extraData));
    }

    public Object visitNullFilter(Object extraData) {
        return null;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return filter;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return filter;
    }

    public Object visit(And filter, Object extraData) {
        return this.filterFactory.and(this.convertChildren((BinaryLogicOperator)filter, extraData));
    }

    public Object visit(Id filter, Object extraData) {
        throw new RuntimeException("Unsupported filter " + String.valueOf(filter));
    }

    public Object visit(Not filter, Object extraData) {
        return this.filterFactory.not((Filter)filter.getFilter().accept((FilterVisitor)this, extraData));
    }

    public Object visit(Or filter, Object extraData) {
        return this.filterFactory.or(this.convertChildren((BinaryLogicOperator)filter, extraData));
    }

    private List<Filter> convertChildren(BinaryLogicOperator filter, Object extraData) {
        ArrayList converted = Lists.newArrayListWithCapacity((int)filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            converted.add((Filter)child.accept((FilterVisitor)this, extraData));
        }
        return converted;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.filterFactory.between((Expression)filter.getExpression().accept((ExpressionVisitor)this, extraData), (Expression)filter.getLowerBoundary().accept((ExpressionVisitor)this, extraData), (Expression)filter.getUpperBoundary().accept((ExpressionVisitor)this, extraData), filter.getMatchAction());
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.filterFactory.equal((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.filterFactory.notEqual((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.filterFactory.greater((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.filterFactory.greaterOrEqual((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.filterFactory.less((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.filterFactory.lessOrEqual((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.filterFactory.like((Expression)filter.getExpression().accept((ExpressionVisitor)this, extraData), filter.getLiteral(), filter.getWildCard(), filter.getSingleChar(), filter.getEscape(), filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.filterFactory.isNull((Expression)filter.getExpression().accept((ExpressionVisitor)this, extraData));
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.filterFactory.isNil((Expression)filter.getExpression().accept((ExpressionVisitor)this, extraData), filter.getNilReason());
    }

    public Object visit(BBOX filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        return new BBOXImpl((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.getMatchAction());
    }

    public Object visit(Beyond filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        return this.filterFactory.beyond((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
    }

    public Object visit(Contains filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.contains(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(Crosses filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.crosses(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(Disjoint filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.disjoint(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(DWithin filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        return this.filterFactory.dwithin((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.getDistance(), filter.getDistanceUnits(), filter.getMatchAction());
    }

    public Object visit(Equals filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        return this.filterFactory.equal((Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData), (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData), filter.getMatchAction());
    }

    public Object visit(Intersects filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.intersects(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(Overlaps filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.overlaps(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(Touches filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.touches(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(Within filter, Object extraData) {
        if (this.supportsVisitSpatialOperator()) {
            return this.visitSpatialOperator((BinarySpatialOperator)filter, extraData);
        }
        Expression expression1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)this, extraData);
        Expression expression2 = (Expression)filter.getExpression2().accept((ExpressionVisitor)this, extraData);
        return this.filterFactory.within(expression1, expression2, filter.getMatchAction());
    }

    public Object visit(PropertyName expression, Object extraData) {
        return this.filterFactory.property(expression.getPropertyName());
    }

    public Object visit(After after, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(Before before, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(During during, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new RuntimeException("Not yet implemented");
    }
}

