/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.grid;

import it.geosolutions.jaiext.jts.CoordinateSequence2D;
import lombok.Generated;
import nz.org.riskscape.engine.geo.OverlayOperations;
import nz.org.riskscape.engine.grid.FeatureGrid;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.geometry.Position2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class FeatureGridCell {
    private final FeatureGrid featureGrid;
    private final int x;
    private final int y;

    FeatureGridCell(FeatureGrid featureGrid, int x, int y) {
        this.featureGrid = featureGrid;
        this.x = x;
        this.y = y;
    }

    public Point getCellCentre() {
        Position2D topLeft = this.featureGrid.getFeatureTopLeft();
        double px = topLeft.x + (double)this.x * this.featureGrid.getCellWorldX();
        double py = topLeft.y + (double)this.y * this.featureGrid.getCellWorldY();
        return this.featureGrid.getGeometryFactory().createPoint(new Coordinate(px, py));
    }

    public Polygon getCellPolygon() {
        Point point = this.getCellCentre();
        double halfWidth = this.featureGrid.getCellWorldX() / 2.0;
        double halfHeight = this.featureGrid.getCellWorldY() / 2.0;
        double x1 = point.getX() - halfWidth;
        double x2 = point.getX() + halfWidth;
        double y1 = point.getY() - halfHeight;
        double y2 = point.getY() + halfHeight;
        return this.featureGrid.getGeometryFactory().createPolygon((CoordinateSequence)new CoordinateSequence2D(new double[]{x1, y1, x1, y2, x2, y2, x2, y1, x1, y1}));
    }

    public Geometry computeIntersection() {
        OverlayOperations ops = OverlayOperations.get();
        return ops.intersection((Geometry)this.getCellPolygon(), this.featureGrid.getFeature());
    }

    public GridCoordinates2D getGridPosition() {
        return new GridCoordinates2D(this.x + this.featureGrid.getGridOffsetX(), this.y + this.featureGrid.getGridOffsetY());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureGridCell)) {
            return false;
        }
        FeatureGridCell other = (FeatureGridCell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureGridCell;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.x;
        result = result * 59 + this.y;
        return result;
    }

    @Generated
    public String toString() {
        return "FeatureGridCell(x=" + this.x + ", y=" + this.y + ")";
    }
}

