/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.grid;

import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import nz.org.riskscape.engine.grid.FeatureGridCell;
import nz.org.riskscape.engine.grid.FeatureGridIterator;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class FeatureGrid {
    public static final double HALF_A_PIXEL = 0.5;
    private final Geometry feature;
    private final CRS.AxisOrder axisOrder;
    private final GridGeometry2D gridGeometry;
    private final Envelope envelope;
    private final MathTransform gridToWorld;
    private final GeometryFactory gf;
    private final int gridColumns;
    private final int gridRows;
    private final int gridOffsetY;
    private final int gridOffsetX;
    private final double cellWidth;
    private final double cellHeight;
    private final Position2D featureTopLeft;

    private static Envelope buildGridEnvelope(Geometry feature, GridGeometry2D gridGeometry) throws MismatchedDimensionException, TransformException {
        MathTransform2D crsToGrid = gridGeometry.getCRSToGrid2D();
        if (!feature.getEnvelopeInternal().intersects((Envelope)gridGeometry.getEnvelope2D())) {
            return new Envelope();
        }
        Envelope featureInGridEnvelope = feature.getEnvelopeInternal().intersection((Envelope)gridGeometry.getEnvelope2D());
        Position featureGridMin = crsToGrid.transform((Position)new Position2D(featureInGridEnvelope.getMinX(), featureInGridEnvelope.getMinY()), null);
        Position featureGridMax = crsToGrid.transform((Position)new Position2D(featureInGridEnvelope.getMaxX(), featureInGridEnvelope.getMaxY()), null);
        GridEnvelope2D gridRange2D = gridGeometry.getGridRange2D();
        Envelope coverageEnvelope = new Envelope(gridRange2D.getMinX(), gridRange2D.getMaxX(), gridRange2D.getMinY(), gridRange2D.getMaxY());
        double minX = Math.floor(FeatureGrid.getMin(featureGridMin, featureGridMax, 0) + 0.5);
        double maxX = Math.ceil(FeatureGrid.getMax(featureGridMin, featureGridMax, 0) + 0.5);
        double minY = Math.floor(FeatureGrid.getMin(featureGridMin, featureGridMax, 1) + 0.5);
        double maxY = Math.ceil(FeatureGrid.getMax(featureGridMin, featureGridMax, 1) + 0.5);
        if (minX == maxX) {
            maxX += 1.0;
        }
        if (minY == maxY) {
            maxY += 1.0;
        }
        return coverageEnvelope.intersection(new Envelope(minX, maxX, minY, maxY));
    }

    private static double getMax(Position featureGridMin, Position featureGridMax, int i) {
        return Math.max(featureGridMax.getOrdinate(i), featureGridMin.getOrdinate(i));
    }

    private static double getMin(Position featureGridMin, Position featureGridMax, int i) {
        return Math.min(featureGridMax.getOrdinate(i), featureGridMin.getOrdinate(i));
    }

    public FeatureGrid(Geometry feature, CRS.AxisOrder axisOrder, GridGeometry2D gridGeometry) throws MismatchedDimensionException, TransformException {
        this.feature = feature;
        this.axisOrder = axisOrder;
        this.gridGeometry = gridGeometry;
        this.gridToWorld = gridGeometry.getGridToCRS2D();
        this.gf = feature.getFactory();
        this.envelope = FeatureGrid.buildGridEnvelope(feature, gridGeometry);
        this.gridColumns = (int)this.envelope.getWidth();
        this.gridRows = (int)this.envelope.getHeight();
        this.gridOffsetY = (int)this.envelope.getMinY();
        this.gridOffsetX = (int)this.envelope.getMinX();
        this.cellWidth = this.computeCellDeltaInWorldSpace(0);
        this.cellHeight = this.computeCellDeltaInWorldSpace(1);
        this.featureTopLeft = this.computeTopLeftInWorldSpace();
    }

    public GeometryFactory getGeometryFactory() {
        return this.gf;
    }

    public Envelope getFeatureGridEnvelopeInWorldCrs() {
        try {
            Position minCrs = this.gridToWorld.transform((Position)new Position2D(this.envelope.getMinX() - 0.5, this.envelope.getMinY() - 0.5), null);
            Position maxCrs = this.gridToWorld.transform((Position)new Position2D(this.envelope.getMaxX() - 0.5, this.envelope.getMaxY() - 0.5), null);
            return new Envelope(minCrs.getOrdinate(0), maxCrs.getOrdinate(0), minCrs.getOrdinate(1), maxCrs.getOrdinate(1));
        }
        catch (MismatchedDimensionException | TransformException e) {
            throw new RuntimeException("this shouldn't happen once construction validates the geometries", e);
        }
    }

    public Iterator<FeatureGridCell> cellIterator() {
        if (this.gridColumns == 0 || this.gridRows == 0) {
            return Collections.emptyIterator();
        }
        return new FeatureGridIterator(this);
    }

    private Position2D computeTopLeftInWorldSpace() throws TransformException {
        MathTransform2D gridToCRS = this.gridGeometry.getGridToCRS2D();
        Position2D gridPoint1 = new Position2D((double)this.gridOffsetX, (double)this.gridOffsetY);
        Position2D crsPoint1 = new Position2D();
        gridToCRS.transform((Position)gridPoint1, (Position)crsPoint1);
        return crsPoint1;
    }

    private double computeCellDeltaInWorldSpace(int ordinate) throws TransformException {
        MathTransform2D gridToCRS = this.gridGeometry.getGridToCRS2D();
        Position2D gridPoint1 = new Position2D((double)this.gridOffsetX, (double)this.gridOffsetY);
        Position2D gridPoint2 = new Position2D((double)this.gridOffsetX, (double)this.gridOffsetY);
        gridPoint2.setOrdinate(ordinate, gridPoint2.getOrdinate(ordinate) + 1.0);
        Position crsPoint1 = gridToCRS.transform((Position)gridPoint1, null);
        Position crsPoint2 = gridToCRS.transform((Position)gridPoint2, null);
        int worldOrdinate = this.axisOrder == CRS.AxisOrder.EAST_NORTH ? ordinate : 1 - ordinate;
        return crsPoint2.getOrdinate(worldOrdinate) - crsPoint1.getOrdinate(worldOrdinate);
    }

    protected double getCellWorldX() {
        return this.axisOrder == CRS.AxisOrder.EAST_NORTH ? this.cellWidth : this.cellHeight;
    }

    protected double getCellWorldY() {
        return this.axisOrder == CRS.AxisOrder.EAST_NORTH ? this.cellHeight : this.cellWidth;
    }

    @Generated
    public Geometry getFeature() {
        return this.feature;
    }

    @Generated
    public GridGeometry2D getGridGeometry() {
        return this.gridGeometry;
    }

    @Generated
    public Envelope getEnvelope() {
        return this.envelope;
    }

    @Generated
    public MathTransform getGridToWorld() {
        return this.gridToWorld;
    }

    @Generated
    public int getGridColumns() {
        return this.gridColumns;
    }

    @Generated
    public int getGridRows() {
        return this.gridRows;
    }

    @Generated
    public int getGridOffsetY() {
        return this.gridOffsetY;
    }

    @Generated
    public int getGridOffsetX() {
        return this.gridOffsetX;
    }

    @Generated
    public double getCellWidth() {
        return this.cellWidth;
    }

    @Generated
    public double getCellHeight() {
        return this.cellHeight;
    }

    @Generated
    public Position2D getFeatureTopLeft() {
        return this.featureTopLeft;
    }
}

