/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.geo.BlockBasedSquareList;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.Quadrant;
import nz.org.riskscape.engine.util.SegmentedList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class RecursiveQuadGridOp {
    private boolean fastIntersectionEnabled = false;

    static int expandForFactor(Envelope featureEnvelope, double gridSize, Coordinate alignTo) {
        RecursiveQuadGridOp.snapEnvelopeCentreTo(featureEnvelope, gridSize, alignTo);
        double target = Math.max(Math.max(featureEnvelope.getWidth(), featureEnvelope.getHeight()), gridSize);
        int exp = 0;
        double size = gridSize;
        while (size <= target) {
            size = gridSize * (double)(1 << ++exp);
        }
        Coordinate centre = featureEnvelope.centre();
        featureEnvelope.setToNull();
        featureEnvelope.expandToInclude(centre);
        featureEnvelope.expandBy(size / 2.0);
        return exp - 1;
    }

    static void snapEnvelopeCentreTo(Envelope featureEnvelope, double gridSize, Coordinate alignTo) {
        Coordinate centre = featureEnvelope.centre();
        Coordinate alignedCentre = new Coordinate(RecursiveQuadGridOp.snapTo(centre.x, alignTo.x, gridSize), RecursiveQuadGridOp.snapTo(centre.y, alignTo.y, gridSize));
        double deltaX = Math.abs(centre.x - alignedCentre.x);
        double deltaY = Math.abs(centre.y - alignedCentre.y);
        double origWidth = featureEnvelope.getWidth();
        double origHeight = featureEnvelope.getHeight();
        featureEnvelope.setToNull();
        featureEnvelope.expandToInclude(alignedCentre);
        featureEnvelope.expandBy(origWidth / 2.0 + deltaX, origHeight / 2.0 + deltaY);
        assert (featureEnvelope.centre().equals2D(alignedCentre));
    }

    static double snapTo(double snapping, double alignedTo, double snapSize) {
        double totalDiff = snapping - alignedTo;
        double alignedTotalDiff = (double)Math.round(totalDiff / snapSize) * snapSize;
        double delta = totalDiff - alignedTotalDiff;
        return snapping - delta;
    }

    public List<? extends Geometry> apply(Geometry originalGeom, double gridSize) {
        return this.applyDetailed(originalGeom, gridSize).getCombinedResult();
    }

    public List<? extends Geometry> apply(Geometry originalGeom, double gridSize, Point alignTo) {
        return this.applyDetailed(originalGeom, gridSize, alignTo.getCoordinate()).getCombinedResult();
    }

    public List<? extends Geometry> apply(Geometry originalGeom, double gridSize, Coordinate alignTo) {
        return this.applyDetailed(originalGeom, gridSize, alignTo).getCombinedResult();
    }

    public Result applyDetailed(Geometry originalGeom, double gridSize) {
        Coordinate alignTo = Quadrant.BL.getCoordinate(originalGeom.getEnvelopeInternal());
        return this.applyDetailed(originalGeom, gridSize, alignTo);
    }

    public Result applyDetailed(Geometry originalGeom, double gridSize, Coordinate alignTo) {
        Result result = new Result(originalGeom, gridSize, alignTo);
        Envelope startingEnvelope = result.getStartingEnvelope();
        LinkedList<QueueElement> queue = new LinkedList<QueueElement>();
        queue.add(new QueueElement(startingEnvelope, originalGeom, 0));
        while (!queue.isEmpty()) {
            QueueElement element = (QueueElement)queue.removeFirst();
            if (element.geometry instanceof GeometryCollection) {
                GeometryCollection coll = (GeometryCollection)element.geometry;
                for (int i = 0; i < coll.getNumGeometries(); ++i) {
                    this.doIntersections(result, queue, new QueueElement(element.envelope, coll.getGeometryN(i), element.depth));
                }
                continue;
            }
            this.doIntersections(result, queue, element);
        }
        return result;
    }

    private void doIntersections(Result result, LinkedList<QueueElement> queue, QueueElement element) {
        EnumMap<Quadrant, Envelope> envelopes = Quadrant.partition(element.envelope);
        this.doIntersections(result, envelopes, queue, element);
    }

    private void doIntersections(Result result, EnumMap<Quadrant, Envelope> envelopes, LinkedList<QueueElement> queue, QueueElement element) {
        GeometryFamily targetFamily = GeometryFamily.from((Geometry)element.geometry);
        for (Envelope envelope : envelopes.values()) {
            LinearRing envRing = RecursiveQuadGridOp.envelopeToRing(element.geometry.getFactory(), envelope);
            Geometry intersection = element.geometry.intersection((Geometry)new Polygon(envRing, null, envRing.getFactory()));
            if (intersection.isEmpty() || (intersection = GeometryUtils.removeNonFamilyMembers((Geometry)intersection, (GeometryFamily)targetFamily)).isEmpty()) continue;
            LinearRing square = this.getPossibleSquare(intersection);
            if (square != null && this.isOverlapping(square, envRing)) {
                result.squares.addBlock(envelope);
                continue;
            }
            if (element.depth < result.maxDepth) {
                queue.add(new QueueElement(envelope, intersection, element.depth + 1));
                continue;
            }
            result.cuts.add(intersection);
        }
    }

    private boolean isOverlapping(LinearRing square, LinearRing envelopeAsRing) {
        Geometry difference = envelopeAsRing.symDifference((Geometry)square);
        return difference.isEmpty();
    }

    private LinearRing getPossibleSquare(Geometry geometry) {
        LinearRing ring;
        Polygon polygon;
        if (geometry instanceof Polygon && (polygon = (Polygon)geometry).getNumInteriorRing() == 0) {
            geometry = polygon.getExteriorRing();
        }
        if (geometry instanceof LinearRing && (ring = (LinearRing)geometry).getCoordinateSequence().size() == 5) {
            return ring;
        }
        return null;
    }

    public static LinearRing envelopeToRing(GeometryFactory factory, Envelope envelope) {
        return new LinearRing((CoordinateSequence)new PackedCoordinateSequence.Double(new Coordinate[]{Quadrant.TL.getCoordinate(envelope), Quadrant.TR.getCoordinate(envelope), Quadrant.BR.getCoordinate(envelope), Quadrant.BL.getCoordinate(envelope), Quadrant.TL.getCoordinate(envelope)}, 2, 0), factory);
    }

    public static class Result {
        public final double gridSize;
        public final GeometryFactory factory;
        public final List<Geometry> cuts = SegmentedList.forClass(Geometry.class);
        public final BlockBasedSquareList squares;
        public final int maxDepth;
        private final Envelope startingEnvelope;

        public Result(Geometry geometry, double gridSize, Coordinate alignTo) {
            this.factory = geometry.getFactory();
            this.gridSize = gridSize;
            this.squares = new BlockBasedSquareList(this.factory, gridSize);
            this.startingEnvelope = geometry.getEnvelopeInternal();
            this.maxDepth = RecursiveQuadGridOp.expandForFactor(this.startingEnvelope, gridSize, alignTo);
        }

        public Envelope getStartingEnvelope() {
            return new Envelope(this.startingEnvelope);
        }

        public List<? extends Geometry> getBlockList() {
            return Lists.transform(this.squares.getBlocks(), block -> new Polygon(RecursiveQuadGridOp.envelopeToRing(this.factory, block), null, this.factory));
        }

        public List<? extends Geometry> getCombinedResult() {
            return new CombinedList(this);
        }
    }

    private static final class QueueElement {
        final Envelope envelope;
        final Geometry geometry;
        final int depth;

        @Generated
        public QueueElement(Envelope envelope, Geometry geometry, int depth) {
            this.envelope = envelope;
            this.geometry = geometry;
            this.depth = depth;
        }
    }

    static class CombinedList
    extends AbstractList<Geometry> {
        private final List<Geometry> cuts;
        private final BlockBasedSquareList squares;

        CombinedList(Result result) {
            this.cuts = result.cuts;
            this.squares = result.squares;
        }

        @Override
        public Geometry get(int index) {
            int cutsSize = this.cuts.size();
            if (index < cutsSize) {
                return this.cuts.get(index);
            }
            return this.squares.get(index - cutsSize);
        }

        @Override
        public Iterator<Geometry> iterator() {
            final Iterator<Geometry> cutsIter = this.cuts.iterator();
            final Iterator<Polygon> squaresIter = this.squares.iterator();
            return new Iterator<Geometry>(){

                @Override
                public boolean hasNext() {
                    return cutsIter.hasNext() || squaresIter.hasNext();
                }

                @Override
                public Geometry next() {
                    if (cutsIter.hasNext()) {
                        return (Geometry)cutsIter.next();
                    }
                    return (Geometry)squaresIter.next();
                }
            };
        }

        @Override
        public int size() {
            return this.cuts.size() + this.squares.size();
        }
    }
}

