/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.EnumMap;
import lombok.Generated;
import nz.org.riskscape.engine.geo.HalfPlane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public enum Quadrant {
    TL(HalfPlane.TOP, HalfPlane.LEFT),
    TR(HalfPlane.TOP, HalfPlane.RIGHT),
    BR(HalfPlane.BOTTOM, HalfPlane.RIGHT),
    BL(HalfPlane.BOTTOM, HalfPlane.LEFT);

    private HalfPlane vertical;
    private HalfPlane horizontal;

    public static EnumMap<Quadrant, Envelope> partition(Envelope envelope) {
        EnumMap<Quadrant, Envelope> map = new EnumMap<Quadrant, Envelope>(Quadrant.class);
        Coordinate centre = envelope.centre();
        for (Quadrant quadrant : Quadrant.values()) {
            Envelope newEnvelope = new Envelope();
            newEnvelope.expandToInclude(centre);
            newEnvelope.expandToInclude(quadrant.getCoordinate(envelope));
            map.put(quadrant, newEnvelope);
        }
        return map;
    }

    private Quadrant(HalfPlane vert, HalfPlane horiz) {
        this.vertical = vert;
        this.horizontal = horiz;
    }

    public Coordinate getCoordinate(Envelope envelope) {
        Coordinate coord = new Coordinate();
        coord.x = this.horizontal == HalfPlane.LEFT ? envelope.getMinX() : envelope.getMaxX();
        coord.y = this.vertical == HalfPlane.BOTTOM ? envelope.getMinY() : envelope.getMaxY();
        return coord;
    }

    @Generated
    public HalfPlane getVertical() {
        return this.vertical;
    }

    @Generated
    public HalfPlane getHorizontal() {
        return this.horizontal;
    }
}

