/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ProjectGeometryOp {
    private final SRIDSet sridSet;

    public List<Projected> apply(Geometry geom) {
        CoordinateReferenceSystem crs = this.sridSet.get(geom);
        if (crs instanceof ProjectedCRS) {
            return Arrays.asList(new Projected(geom, crs, geom, crs, null));
        }
        Point centroid = this.sridSet.reproject((Geometry)geom.getCentroid(), this.sridSet.get(SRIDSet.EPSG4326_LATLON)).getCentroid();
        CoordinateReferenceSystem autoCrs = null;
        double latitude = centroid.getX();
        double longitude = centroid.getY();
        try {
            autoCrs = CRS.decode((String)String.format("AUTO2:42001,0.9996,%f,%f", longitude, latitude));
            MathTransform transform = this.sridSet.getReprojectionTransform(geom.getSRID(), this.sridSet.get(autoCrs));
            return Arrays.asList(new Projected(geom, crs, this.sridSet.reproject(geom, transform, crs, autoCrs), autoCrs, transform.inverse()));
        }
        catch (TransformException e) {
            throw new RiskscapeException((Problems)GeometryProblems.get().cannotReproject(geom, crs, autoCrs));
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new RiskscapeException((Problems)GeometryProblems.get().autoProjectionNotFound(latitude, longitude));
        }
        catch (FactoryException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    @Generated
    public ProjectGeometryOp(SRIDSet sridSet) {
        this.sridSet = sridSet;
    }

    public class Projected {
        private final Geometry source;
        private final CoordinateReferenceSystem sourceCrs;
        private final Geometry projected;
        private final CoordinateReferenceSystem projectedCrs;
        private final MathTransform projectedToSource;

        public Geometry toSourceCrs(Geometry geom) {
            if (this.projectedToSource == null) {
                return geom;
            }
            try {
                Geometry reprojected = ProjectGeometryOp.this.sridSet.reproject(geom, this.projectedToSource, this.projectedCrs, this.sourceCrs);
                reprojected.setSRID(this.source.getSRID());
                return reprojected;
            }
            catch (TransformException e) {
                throw new RiskscapeException((Problems)GeometryProblems.get().cannotReproject(geom, this.projectedCrs, this.sourceCrs));
            }
        }

        public Geometry projectAlso(Geometry geom) {
            Geometry reprojected = ProjectGeometryOp.this.sridSet.reproject(geom, this.source.getSRID());
            List<Projected> projectedGeom = ProjectGeometryOp.this.apply(reprojected);
            if (projectedGeom.size() != 1) {
                throw new RiskscapeException("Internal error reprojecting single geometry");
            }
            return projectedGeom.get(0).getProjected();
        }

        @Generated
        public Projected(Geometry source, CoordinateReferenceSystem sourceCrs, Geometry projected, CoordinateReferenceSystem projectedCrs, MathTransform projectedToSource) {
            this.source = source;
            this.sourceCrs = sourceCrs;
            this.projected = projected;
            this.projectedCrs = projectedCrs;
            this.projectedToSource = projectedToSource;
        }

        @Generated
        public Geometry getSource() {
            return this.source;
        }

        @Generated
        public CoordinateReferenceSystem getSourceCrs() {
            return this.sourceCrs;
        }

        @Generated
        public Geometry getProjected() {
            return this.projected;
        }

        @Generated
        public CoordinateReferenceSystem getProjectedCrs() {
            return this.projectedCrs;
        }

        @Generated
        public MathTransform getProjectedToSource() {
            return this.projectedToSource;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Projected)) {
                return false;
            }
            Projected other = (Projected)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Geometry this$source = this.getSource();
            Geometry other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            CoordinateReferenceSystem this$sourceCrs = this.getSourceCrs();
            CoordinateReferenceSystem other$sourceCrs = other.getSourceCrs();
            if (this$sourceCrs == null ? other$sourceCrs != null : !this$sourceCrs.equals(other$sourceCrs)) {
                return false;
            }
            Geometry this$projected = this.getProjected();
            Geometry other$projected = other.getProjected();
            if (this$projected == null ? other$projected != null : !this$projected.equals(other$projected)) {
                return false;
            }
            CoordinateReferenceSystem this$projectedCrs = this.getProjectedCrs();
            CoordinateReferenceSystem other$projectedCrs = other.getProjectedCrs();
            if (this$projectedCrs == null ? other$projectedCrs != null : !this$projectedCrs.equals(other$projectedCrs)) {
                return false;
            }
            MathTransform this$projectedToSource = this.getProjectedToSource();
            MathTransform other$projectedToSource = other.getProjectedToSource();
            return !(this$projectedToSource == null ? other$projectedToSource != null : !this$projectedToSource.equals(other$projectedToSource));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Projected;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Geometry $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            CoordinateReferenceSystem $sourceCrs = this.getSourceCrs();
            result = result * 59 + ($sourceCrs == null ? 43 : $sourceCrs.hashCode());
            Geometry $projected = this.getProjected();
            result = result * 59 + ($projected == null ? 43 : $projected.hashCode());
            CoordinateReferenceSystem $projectedCrs = this.getProjectedCrs();
            result = result * 59 + ($projectedCrs == null ? 43 : $projectedCrs.hashCode());
            MathTransform $projectedToSource = this.getProjectedToSource();
            result = result * 59 + ($projectedToSource == null ? 43 : $projectedToSource.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectGeometryOp.Projected(source=" + String.valueOf(this.getSource()) + ", sourceCrs=" + String.valueOf(this.getSourceCrs()) + ", projected=" + String.valueOf(this.getProjected()) + ", projectedCrs=" + String.valueOf(this.getProjectedCrs()) + ", projectedToSource=" + String.valueOf(this.getProjectedToSource()) + ")";
        }
    }
}

